/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtensionFileNameMatcher
implements FileNameMatcher {
    private final String myExtension;

    public ExtensionFileNameMatcher(@NotNull @NonNls String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/ExtensionFileNameMatcher.<init> must not be null");
        }
        this.myExtension = extension.toLowerCase();
    }

    @Override
    public boolean accept(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/ExtensionFileNameMatcher.accept must not be null");
        }
        return fileName.regionMatches(true, fileName.length() - this.myExtension.length() - 1, "." + this.myExtension, 0, this.myExtension.length() + 1);
    }

    @Override
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = "*." + this.myExtension;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/ExtensionFileNameMatcher.getPresentableString must not return null");
        }
        return string;
    }

    public String getExtension() {
        return this.myExtension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionFileNameMatcher that = (ExtensionFileNameMatcher)o;
        return this.myExtension.equals(that.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }
}

