/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeFileEncodingTo
extends AnAction
implements DumbAware {
    private final VirtualFile myFile;
    private final Charset myCharset;

    ChangeFileEncodingTo(@Nullable VirtualFile file, @NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/encoding/ChangeFileEncodingTo.<init> must not be null");
        }
        super(charset.toString(), "Change " + (file == null ? "default" : "file '" + file.getName() + "'") + " encoding to '" + charset.displayName() + "'.", null);
        this.myFile = file;
        this.myCharset = charset;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        this.chosen(this.myFile, this.myCharset);
    }

    protected void chosen(VirtualFile file, Charset charset) {
        EncodingManager.getInstance().setEncoding(file, charset);
    }
}

