/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.IsConstantExpressionVisitor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiUtil
extends PsiUtilBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PsiUtil");
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create((String)"VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create((String)"FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            return PsiUtilBase.compareElementsByPosition(o1, o2);
        }
    };

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(PsiExpression expr) {
        PsiElement parent = expr.getParent();
        return parent instanceof PsiAssignmentExpression && expr.equals(((PsiAssignmentExpression)parent).getLExpression());
    }

    public static boolean isAccessibleFromPackage(@NotNull PsiModifierListOwner element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isAccessibleFromPackage must not be null");
        }
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isAccessibleFromPackage must not be null");
        }
        if (element.hasModifierProperty("public")) {
            return true;
        }
        return !element.hasModifierProperty("private") && JavaPsiFacade.getInstance(element.getProject()).isInPackage(element, aPackage);
    }

    public static boolean isAccessedForWriting(PsiExpression expr) {
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof PsiPrefixExpression) {
            IElementType tokenType = ((PsiPrefixExpression)parent).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        if (parent instanceof PsiPostfixExpression) {
            IElementType tokenType = ((PsiPostfixExpression)parent).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    public static boolean isAccessedForReading(PsiExpression expr) {
        PsiElement parent = expr.getParent();
        return !(parent instanceof PsiAssignmentExpression) || !expr.equals(((PsiAssignmentExpression)parent).getLExpression()) || ((PsiAssignmentExpression)parent).getOperationSign().getTokenType() != JavaTokenType.EQ;
    }

    public static boolean isAccessible(PsiMember member, @NotNull PsiElement place, PsiClass accessObjectClass) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isAccessible must not be null");
        }
        return JavaPsiFacade.getInstance(place.getProject()).getResolveHelper().isAccessible(member, place, accessObjectClass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static JavaResolveResult getAccessObjectClass(PsiExpression expression) {
        JavaResolveResult resolveResult;
        JavaResolveResult javaResolveResult;
        if (expression instanceof PsiSuperExpression || expression instanceof PsiThisExpression) {
            javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getAccessObjectClass must not return null");
            return javaResolveResult;
        }
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            javaResolveResult = ((PsiClassType)type).resolveGenerics();
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getAccessObjectClass must not return null");
            return javaResolveResult;
        }
        if (type == null && expression instanceof PsiReferenceExpression && (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement() instanceof PsiClass) {
            javaResolveResult = resolveResult;
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getAccessObjectClass must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getAccessObjectClass must not return null");
    }

    public static boolean isConstantExpression(PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor();
        expression.accept(visitor);
        return visitor.myIsConstant;
    }

    public static void addException(PsiMethod method, @NonNls String exceptionFQName) throws IncorrectOperationException {
        PsiClass exceptionClass = JavaPsiFacade.getInstance(method.getProject()).findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(PsiMethod method, PsiClass exceptionClass) throws IncorrectOperationException {
        PsiUtil.addException(method, exceptionClass, exceptionClass.getQualifiedName());
    }

    private static void addException(PsiMethod method, PsiClass exceptionClass, String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        PsiJavaCodeReferenceElement[] refs;
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiJavaCodeReferenceElement ref2 : refs = throwsList.getReferenceElements()) {
            if (ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass == null) continue;
            if (aClass.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
                if (exceptionName != null) {
                    ref1 = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type = factory.createType(exceptionClass);
                    ref1 = factory.createReferenceElementByType(type);
                }
                ref2.replace(ref1);
                return;
            }
            if (!exceptionClass.isInheritor(aClass, true)) continue;
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        if (exceptionName != null) {
            ref = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClassType type = factory.createType(exceptionClass);
            ref = factory.createReferenceElementByType(type);
        }
        throwsList.add(ref);
    }

    public static void removeException(PsiMethod method, @NonNls String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(@NotNull String name, @NotNull PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isVariableNameUnique must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isVariableNameUnique must not be null");
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper();
        return helper.resolveReferencedVariable(name, place) == null;
    }

    public static PsiElement getTopLevelEnclosingCodeBlock(PsiElement element, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element != null) {
            PsiElement parent;
            if (element instanceof PsiCodeBlock || element instanceof PsiForStatement || element instanceof PsiForeachStatement) {
                blockSoFar = element;
            }
            if ((parent = element.getParent()) instanceof PsiMethod && parent.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent.getParent()) || parent instanceof PsiClassInitializer && !(parent.getParent() instanceof PsiAnonymousClass)) break;
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                blockSoFar = element;
            }
            if (parent instanceof PsiClassLevelDeclarationStatement) {
                parent = parent.getParent();
            }
            if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) break;
            if (PsiUtilBase.getTemplateLanguageFile(element) != null && element instanceof PsiFile) {
                return element;
            }
            if (element == scope) break;
            element = parent;
        }
        return blockSoFar;
    }

    public static boolean isLocalOrAnonymousClass(PsiClass psiClass) {
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(PsiClass psiClass) {
        PsiElement parent = psiClass.getParent();
        return parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock;
    }

    public static boolean isAbstractClass(PsiClass clazz) {
        PsiModifierList modifierList = clazz.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    @Nullable
    public static PsiElement getVariableCodeBlock(PsiVariable variable, PsiElement context) {
        PsiElement codeBlock = null;
        if (variable instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            }
        } else {
            if (variable instanceof PsiLocalVariable && variable.getParent() instanceof PsiForStatement) {
                return variable.getParent();
            }
            if (variable instanceof PsiField && context != null) {
                PsiClass aClass = ((PsiField)variable).getContainingClass();
                while (context != null && context.getParent() != aClass) {
                    if (!((context = context.getParent()) instanceof PsiClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context instanceof PsiMethod ? ((PsiMethod)context).getBody() : (context instanceof PsiClassInitializer ? ((PsiClassInitializer)context).getBody() : null);
            }
            PsiElement scope = variable.getParent() == null ? null : variable.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    public static boolean isIncrementDecrementOperation(PsiElement element) {
        IElementType sign;
        return element instanceof PsiPostfixExpression ? (sign = ((PsiPostfixExpression)element).getOperationSign().getTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS : element instanceof PsiPrefixExpression && ((sign = ((PsiPrefixExpression)element).getOperationSign().getTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS);
    }

    public static int getAccessLevel(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getAccessLevel must not be null");
        }
        if (modifierList.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @Modifier
    @Nullable
    public static String getAccessModifier(int accessLevel) {
        return accessLevel > accessModifiers.length ? null : accessModifiers[accessLevel - 1];
    }

    public static boolean isStatement(PsiElement element) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            if (!(parent instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (element != forStatement.getInitialization() && element != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element).getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof PsiExpressionStatement) {
            return PsiUtil.isStatement(((PsiExpressionStatement)element).getExpression());
        }
        if (element instanceof PsiDeclarationStatement) {
            if (parent instanceof PsiCodeBlock) {
                return true;
            }
            if (parent instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent instanceof PsiForStatement) || ((PsiForStatement)parent).getBody() == element) {
                return false;
            }
        }
        if (element instanceof PsiStatement) {
            return true;
        }
        if (element instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element)) {
            return true;
        }
        if (element instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element).getType() instanceof PsiArrayType);
        }
        return element instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getEnclosingStatement(PsiElement element) {
        while (element != null) {
            if (element.getParent() instanceof PsiCodeBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementInclusiveRange(PsiElement scope, TextRange range) {
        PsiElement psiElement;
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiClass resolveClassInType(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type).getComponentType());
        }
        return null;
    }

    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            return classType.resolveGenerics();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveGenericsClassInType(((PsiArrayType)type).getComponentType());
        }
        return PsiClassType.ClassResolveResult.EMPTY;
    }

    public static PsiType convertAnonymousToBaseType(PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInType(type);
        if (psiClass instanceof PsiAnonymousClass) {
            int dims = type.getArrayDimensions();
            type = ((PsiAnonymousClass)psiClass).getBaseClassType();
            while (dims != 0) {
                type = type.createArrayType();
                --dims;
            }
        }
        return type;
    }

    public static boolean isApplicable(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpressionList argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpression[] argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, (PsiType[])ContainerUtil.map2Array((Object[])argList, PsiType.class, PsiExpression.EXPRESSION_TO_TYPE), PsiUtil.getLanguageLevel(method)) != 1;
    }

    public static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpressionList argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList.getExpressionTypes(), PsiUtil.getLanguageLevel(argList));
    }

    public static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiType[] args, LanguageLevel languageLevel) {
        PsiParameter[] parms = method.getParameterList().getParameters();
        if (args.length < parms.length - 1) {
            return 1;
        }
        if (!PsiUtil.areFirstArgumentsApplicable(args, parms, languageLevel, substitutorForMethod)) {
            return 1;
        }
        if (args.length == parms.length) {
            if (parms.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parms[parms.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args[args.length - 1];
            if (argType == null) {
                return 1;
            }
            if (TypeConversionUtil.isAssignable(parmType, argType)) {
                return 3;
            }
        }
        if (method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            if (args.length < parms.length) {
                return 2;
            }
            PsiParameter lastParameter = parms[parms.length - 1];
            if (!lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            lastParmType = ((PsiArrayType)lastParmType).getComponentType();
            for (int i = parms.length - 1; i < args.length; ++i) {
                PsiType argType = args[i];
                if (argType != null && TypeConversionUtil.isAssignable(lastParmType, argType)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(PsiType[] args, PsiParameter[] parms, LanguageLevel languageLevel, PsiSubstitutor substitutorForMethod) {
        for (int i = 0; i < parms.length - 1; ++i) {
            PsiType type = args[i];
            if (type == null) {
                return false;
            }
            PsiParameter parameter = parms[i];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter, languageLevel, substitutorForMethod);
            if (TypeConversionUtil.isAssignable(substitutedParmType, type)) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter parameter, LanguageLevel languageLevel, PsiSubstitutor substitutor) {
        PsiType parmType = parameter.getType();
        if (parmType instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor.substitute(parmType);
    }

    public static boolean equalOnClass(PsiSubstitutor s1, PsiSubstitutor s2, PsiClass aClass) {
        return PsiUtil.equalOnEquivalentClasses(s1, aClass, s2, aClass);
    }

    public static boolean equalOnEquivalentClasses(PsiSubstitutor s1, PsiClass aClass, PsiSubstitutor s2, PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (aClass.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < typeParameters1.length; ++i) {
            if (Comparing.equal((Object)s1.substitute(typeParameters1[i]), (Object)s2.substitute(typeParameters2[i]))) continue;
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        return containingClass1 == null && containingClass2 == null;
    }

    public static boolean isCompileTimeConstant(PsiField field) {
        return field.hasModifierProperty("final") && (TypeConversionUtil.isPrimitiveAndNotNull(field.getType()) || field.getType().equalsToText("java.lang.String")) && field.hasInitializer() && PsiUtil.isConstantExpression(field.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(PsiMethod[] methods) {
        if (methods.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i = 1; i < methods.length; ++i) {
            PsiMethod method = methods[i];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiExpression deparenthesizeExpression(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    public static boolean isInnerClass(PsiClass aClass) {
        return !aClass.hasModifierProperty("static") && aClass.getContainingClass() != null;
    }

    @Nullable
    public static PsiElement findModifierInList(@NotNull PsiModifierList modifierList, @NonNls String modifier) {
        PsiElement[] children;
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.findModifierInList must not be null");
        }
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static PsiClass getTopLevelClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getTopLevelClass must not be null");
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiJavaFile) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = ((PsiJavaFile)file).getClasses()) {
                if (!PsiTreeUtil.isAncestor(aClass, element, false)) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getEnclosingStaticElement(PsiElement place, @Nullable PsiClass aClass) {
        LOG.assertTrue(aClass == null || !place.isPhysical() || PsiTreeUtil.isContextAncestor(aClass, place, false));
        for (PsiElement parent = place; parent != aClass && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent;
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByPsiElement(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    public static PsiType captureToplevelWildcards(PsiType type, PsiElement context) {
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                HashMap substitutionMap = null;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType substituted = substitutor.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap(substitutor.getSubstitutionMap());
                    }
                    substitutionMap.put(typeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context));
                }
                if (substitutionMap != null) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
                    PsiSubstitutor newSubstitutor = factory.createSubstitutor((Map<PsiTypeParameter, PsiType>)substitutionMap);
                    return factory.createType(aClass, newSubstitutor);
                }
            }
        } else if (type instanceof PsiArrayType) {
            return PsiUtil.captureToplevelWildcards(((PsiArrayType)type).getComponentType(), context).createArrayType();
        }
        return type;
    }

    public static boolean isInsideJavadocComment(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiDocComment.class, true) != null;
    }

    public static boolean isAssigned(PsiParameter parameter) {
        ParamWriteProcessor processor = new ParamWriteProcessor();
        ReferencesSearch.search(parameter, new LocalSearchScope(parameter.getDeclarationScope()), true).forEach((Processor)processor);
        return processor.isWriteRefFound();
    }

    public static void checkIsIdentifier(PsiManager manager, String text) throws IncorrectOperationException {
        if (!JavaPsiFacade.getInstance(manager.getProject()).getNameHelper().isIdentifier(text)) {
            throw new IncorrectOperationException(PsiBundle.message("0.is.not.an.identifier", text));
        }
    }

    public static Iterator<PsiTypeParameter> typeParametersIterator(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.typeParametersIterator must not be null");
        }
        return new TypeParameterIterator(owner);
    }

    public static Iterable<PsiTypeParameter> typeParametersIterable(final @NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.typeParametersIterable must not be null");
        }
        return new Iterable<PsiTypeParameter>(){

            @Override
            public Iterator<PsiTypeParameter> iterator() {
                return PsiUtil.typeParametersIterator(owner);
            }
        };
    }

    public static boolean canBeOverriden(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    public static PsiElement[] mapElements(ResolveResult[] candidates) {
        PsiElement[] result = new PsiElement[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            result[i] = candidates[i].getElement();
        }
        return result;
    }

    @Nullable
    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression) {
        PsiMember parent = (PsiMember)PsiTreeUtil.getParentOfType(expression, PsiClassInitializer.class, PsiMethod.class);
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            return null;
        }
        return parent;
    }

    public static boolean checkName(PsiElement element, String name, PsiElement context) {
        PsiMetaData data;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            return name.equals(data.getName(context));
        }
        return element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName());
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, PsiSubstitutor substitutor) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isRawSubstitutor must not be null");
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanguageLevel5OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isLanguageLevel5OrHigher must not be null");
        }
        return PsiUtil.getLanguageLevel(element).compareTo(LanguageLevel.JDK_1_5) >= 0;
    }

    public static boolean isLanguageLevel6OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isLanguageLevel6OrHigher must not be null");
        }
        return PsiUtil.getLanguageLevel(element).compareTo(LanguageLevel.JDK_1_6) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        LanguageLevel languageLevel;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getLanguageLevel must not be null");
        }
        if (element instanceof PsiDirectory) {
            languageLevel = JavaDirectoryService.getInstance().getLanguageLevel((PsiDirectory)element);
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
            return languageLevel;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            languageLevel = LanguageLevelProjectExtension.getInstance(element.getProject()).getLanguageLevel();
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
            return languageLevel;
        }
        if (!(file instanceof PsiJavaFile)) {
            PsiElement context = file.getContext();
            if (!(context != null ? (languageLevel = PsiUtil.getLanguageLevel(context)) != null : (languageLevel = LanguageLevelProjectExtension.getInstance(file.getProject()).getLanguageLevel()) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
            return languageLevel;
        }
        languageLevel = ((PsiJavaFile)file).getLanguageLevel();
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
    }

    public static boolean isInstantiatable(PsiClass clazz) {
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(PsiClass clazz) {
        return PsiUtil.hasDefaultConstructor(clazz, false);
    }

    public static boolean hasDefaultConstructor(PsiClass clazz, boolean allowProtected) {
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod cls : constructors) {
                if (!cls.hasModifierProperty("public") && (!allowProtected || !cls.hasModifierProperty("protected")) || cls.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
        } else {
            PsiClass superClass = clazz.getSuperClass();
            return superClass == null || PsiUtil.hasDefaultConstructor(superClass);
        }
        return false;
    }

    @Nullable
    public static PsiType extractIterableTypeParameter(@Nullable PsiType psiType, boolean eraseTypeParameter) {
        PsiType type = PsiUtil.substituteTypeParameter(psiType, "java.lang.Iterable", 0, eraseTypeParameter);
        return type != null ? type : PsiUtil.substituteTypeParameter(psiType, "java.util.Collection", 0, eraseTypeParameter);
    }

    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType, String superClass, int typeParamIndex, boolean eraseTypeParameter) {
        if (psiType == null) {
            return null;
        }
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(superClass, psiClass.getResolveScope());
        if (baseClass == null) {
            return null;
        }
        if (!psiClass.isEquivalentTo(baseClass) && !psiClass.isInheritor(baseClass, true)) {
            return null;
        }
        PsiTypeParameter[] parameters = baseClass.getTypeParameters();
        if (parameters.length <= typeParamIndex) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(baseClass, psiClass, classResolveResult.getSubstitutor());
        PsiType type = substitutor.substitute(parameters[typeParamIndex]);
        if (type == null && eraseTypeParameter) {
            return TypeConversionUtil.typeParameterErasure(parameters[typeParamIndex]);
        }
        return type;
    }

    public static void setModifierProperty(@NotNull PsiModifierListOwner owner, @NotNull @Modifier String property, boolean value) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.setModifierProperty must not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtil.setModifierProperty must not be null");
        }
        owner.getModifierList().setModifierProperty(property, value);
    }

    private static class TypeParameterIterator
    implements Iterator<PsiTypeParameter> {
        private int myIndex;
        private PsiTypeParameterListOwner myCurrentOwner;
        private boolean myNextObtained;
        private PsiTypeParameter[] myCurrentParams;
        private PsiTypeParameter myNext;

        private TypeParameterIterator(PsiTypeParameterListOwner owner) {
            this.myCurrentOwner = owner;
            this.obtainCurrentParams(owner);
            this.myNextObtained = false;
        }

        private void obtainCurrentParams(PsiTypeParameterListOwner owner) {
            this.myCurrentParams = owner.getTypeParameters();
            this.myIndex = this.myCurrentParams.length - 1;
        }

        @Override
        public boolean hasNext() {
            this.nextElement();
            return this.myNext != null;
        }

        @Override
        public PsiTypeParameter next() {
            this.nextElement();
            if (this.myNext == null) {
                throw new NoSuchElementException();
            }
            this.myNextObtained = false;
            return this.myNext;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TypeParameterIterator.remove");
        }

        private void nextElement() {
            if (this.myNextObtained) {
                return;
            }
            if (this.myIndex >= 0) {
                this.myNext = this.myCurrentParams[this.myIndex--];
                this.myNextObtained = true;
                return;
            }
            PsiClass containingClass = this.myCurrentOwner.getContainingClass();
            if (this.myCurrentOwner.hasModifierProperty("static") || containingClass == null) {
                this.myNext = null;
                this.myNextObtained = true;
                return;
            }
            this.myCurrentOwner = containingClass;
            this.obtainCurrentParams(this.myCurrentOwner);
            this.nextElement();
        }
    }

    private static class ParamWriteProcessor
    implements Processor<PsiReference> {
        private volatile boolean myIsWriteRefFound = false;

        private ParamWriteProcessor() {
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            if (element instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)element)) {
                this.myIsWriteRefFound = true;
                return false;
            }
            return true;
        }

        public boolean isWriteRefFound() {
            return this.myIsWriteRefFound;
        }
    }
}

