/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.InplaceButton;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

class DragHelper
extends MouseDragHelper {
    JBTabsImpl myTabs;
    TabInfo myDragSource;
    Rectangle myDragOriginalRec;
    Rectangle myDragRec;
    Dimension myHoldDelta;
    Measurer myHorizontal = new Measurer.Width();
    Measurer myVertical = new Measurer.Height();

    public DragHelper(JBTabsImpl tabs) {
        super(tabs, tabs);
        this.myTabs = tabs;
    }

    @Override
    protected void processDrag(MouseEvent event, Point targetScreenPoint, Point startPointScreen) {
        TabLabel targetLabel;
        if (!this.myTabs.isTabDraggingEnabled()) {
            return;
        }
        SwingUtilities.convertPointFromScreen(startPointScreen, this.myTabs);
        if (this.isDragJustStarted()) {
            TabLabel label = this.findLabel(startPointScreen);
            Rectangle labelBounds = label.getBounds();
            this.myHoldDelta = new Dimension(startPointScreen.x - labelBounds.x, startPointScreen.y - labelBounds.y);
            this.myDragSource = label.getInfo();
            this.myDragRec = new Rectangle(startPointScreen, labelBounds.getSize());
            this.myDragOriginalRec = (Rectangle)this.myDragRec.clone();
            this.myDragOriginalRec.x -= this.myHoldDelta.width;
            this.myDragOriginalRec.y -= this.myHoldDelta.height;
        } else {
            Point toPoint = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this.myTabs);
            this.myDragRec.x = toPoint.x;
            this.myDragRec.y = toPoint.y;
        }
        this.myDragRec.x -= this.myHoldDelta.width;
        this.myDragRec.y -= this.myHoldDelta.height;
        Rectangle headerRec = this.myTabs.myLastLayoutPass.getHeaderRectangle();
        ScreenUtil.moveToFit(this.myDragRec, headerRec, null);
        int deadZoneX = 0;
        int deadZoneY = 0;
        TabLabel top = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width / 2, this.myDragRec.y + deadZoneY));
        TabLabel bottom = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width / 2, this.myDragRec.y + this.myDragRec.height - deadZoneY));
        TabLabel left = this.findLabel(new Point(this.myDragRec.x + deadZoneX, this.myDragRec.y + this.myDragRec.height / 2));
        TabLabel right = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width - deadZoneX, this.myDragRec.y + this.myDragRec.height / 2));
        if (this.myTabs.isHorizontalTabs()) {
            targetLabel = this.findMostOverlapping(this.myHorizontal, left, right);
            if (targetLabel == null) {
                targetLabel = this.findMostOverlapping(this.myVertical, top, bottom);
            }
        } else {
            targetLabel = this.findMostOverlapping(this.myVertical, top, bottom);
            if (targetLabel == null) {
                targetLabel = this.findMostOverlapping(this.myHorizontal, left, right);
            }
        }
        if (targetLabel != null) {
            Rectangle saved = this.myDragRec;
            this.myDragRec = null;
            this.myTabs.reallocate(this.myDragSource, targetLabel.getInfo(), true);
            this.myDragOriginalRec = this.myTabs.myInfo2Label.get(this.myDragSource).getBounds();
            this.myDragRec = saved;
            this.myTabs.moveDraggedTabLabel();
        } else {
            this.myTabs.moveDraggedTabLabel();
            int border = this.myTabs.getTabsBorder().getTabBorderSize();
            headerRec.x -= border;
            headerRec.y -= border;
            headerRec.width += border * 2;
            headerRec.height += border * 2;
            this.myTabs.repaint(headerRec);
        }
    }

    private TabLabel findMostOverlapping(Measurer measurer, TabLabel ... labels) {
        double freeSpace = measurer.getMinValue(this.myDragRec) < measurer.getMinValue(this.myDragOriginalRec) ? (double)(measurer.getMaxValue(this.myDragOriginalRec) - measurer.getMaxValue(this.myDragRec)) : (double)(measurer.getMinValue(this.myDragRec) - measurer.getMinValue(this.myDragOriginalRec));
        int max = -1;
        TabLabel maxLabel = null;
        for (TabLabel each : labels) {
            Rectangle eachBounds;
            if (each == null || (double)measurer.getMeasuredValue(eachBounds = each.getBounds()) > freeSpace + freeSpace * 0.3) continue;
            Rectangle intersection = this.myDragRec.intersection(eachBounds);
            int size = intersection.width * intersection.height;
            if (size <= max) continue;
            max = size;
            maxLabel = each;
        }
        return maxLabel;
    }

    @Nullable
    private TabLabel findLabel(Point dragPoint) {
        Component at = this.myTabs.findComponentAt(dragPoint);
        if (at instanceof InplaceButton) {
            return null;
        }
        TabLabel label = this.findLabel(at);
        return label != null && label.getParent() == this.myTabs && label.getInfo() != this.myDragSource ? label : null;
    }

    @Nullable
    private TabLabel findLabel(Component c) {
        for (Component eachParent = c; eachParent != null && eachParent != this.myTabs; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof TabLabel)) continue;
            return (TabLabel)eachParent;
        }
        return null;
    }

    @Override
    protected boolean canStartDragging(JComponent dragComponent, Point dragComponentPoint) {
        return this.findLabel(dragComponentPoint) != null;
    }

    @Override
    protected void processDragFinish(MouseEvent even) {
        this.myDragSource = null;
        this.myDragRec = null;
        this.myTabs.resetTabsCache();
        this.myTabs.relayout(true, false);
    }

    static interface Measurer {
        public int getMinValue(Rectangle var1);

        public int getMaxValue(Rectangle var1);

        public int getMeasuredValue(Rectangle var1);

        public static class Height
        implements Measurer {
            @Override
            public int getMinValue(Rectangle r) {
                return r.y;
            }

            @Override
            public int getMaxValue(Rectangle r) {
                return (int)r.getMaxY();
            }

            @Override
            public int getMeasuredValue(Rectangle r) {
                return r.height;
            }
        }

        public static class Width
        implements Measurer {
            @Override
            public int getMinValue(Rectangle r) {
                return r.x;
            }

            @Override
            public int getMaxValue(Rectangle r) {
                return (int)r.getMaxX();
            }

            @Override
            public int getMeasuredValue(Rectangle r) {
                return r.width;
            }
        }
    }
}

