/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import java.awt.Insets;

public class TabsBorder {
    private Insets myBorderSize;
    private int myTabBorderSize;
    private final JBTabsImpl myTabs;
    private JBTabsPosition myPosition;
    private Insets myEffectiveBorder;

    public TabsBorder(JBTabsImpl tabs) {
        this.myTabs = tabs;
        this.myBorderSize = new Insets(JBTabsImpl.getBorder(-1), JBTabsImpl.getBorder(-1), JBTabsImpl.getBorder(-1), JBTabsImpl.getBorder(-1));
        this.myTabBorderSize = JBTabsImpl.getBorder(-1);
    }

    public JBTabsPresentation setPaintBorder(int top, int left, int right, int bottom) {
        Insets newBorder = new Insets(JBTabsImpl.getBorder(top), JBTabsImpl.getBorder(left), JBTabsImpl.getBorder(bottom), JBTabsImpl.getBorder(right));
        if (newBorder.equals(this.myBorderSize)) {
            return this.myTabs;
        }
        this.myBorderSize = newBorder;
        this.myEffectiveBorder = null;
        this.myTabs.revalidateAndRepaint(false);
        return this.myTabs;
    }

    public JBTabsPresentation setTabSidePaintBorder(int size) {
        int newSize = JBTabsImpl.getBorder(size);
        if (this.myTabBorderSize == newSize) {
            return this.myTabs;
        }
        this.myTabBorderSize = newSize;
        this.myEffectiveBorder = null;
        this.myTabs.revalidateAndRepaint(false);
        return this.myTabs;
    }

    public int getTabBorderSize() {
        return this.myTabBorderSize;
    }

    public Insets getEffectiveBorder() {
        if (this.myEffectiveBorder != null && this.myTabs.getTabsPosition() == this.myPosition) {
            return (Insets)this.myEffectiveBorder.clone();
        }
        this.myPosition = this.myTabs.getTabsPosition();
        this.myEffectiveBorder = new Insets(this.myPosition == JBTabsPosition.top ? this.myTabBorderSize : this.myBorderSize.top, this.myPosition == JBTabsPosition.left ? this.myTabBorderSize : this.myBorderSize.left, this.myPosition == JBTabsPosition.bottom ? this.myTabBorderSize : this.myBorderSize.bottom, this.myPosition == JBTabsPosition.right ? this.myTabBorderSize : this.myBorderSize.right);
        return (Insets)this.myEffectiveBorder.clone();
    }
}

