/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomIconProvider;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.TypeNameManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementPresentationManager {
    private static final ConcurrentFactoryMap<Class, Method> ourNameValueMethods = new ConcurrentFactoryMap<Class, Method>(){

        @Nullable
        protected Method create(Class key) {
            for (Method method : ReflectionCache.getMethods((Class)key)) {
                if (DomReflectionUtil.findAnnotationDFS(method, NameValue.class) == null) continue;
                return method;
            }
            return null;
        }
    };
    private static final Function<Object, String> DEFAULT_NAMER = new Function<Object, String>(){

        @Nullable
        public String fun(Object element) {
            return ElementPresentationManager.getElementName(element);
        }
    };
    private static final Map<Class, Icon[]> ourIcons = new HashMap<Class, Icon[]>();
    private static final List<Function<Object, String>> ourNameProviders = new ArrayList<Function<Object, String>>();
    private static final List<Function<Object, String>> ourDocumentationProviders = new ArrayList<Function<Object, String>>();
    private static final List<Function<Object, Icon>> ourIconProviders = new ArrayList<Function<Object, Icon>>();
    public static final NullableFunction<Object, String> NAMER;

    public static ElementPresentationManager getInstance() {
        return ServiceManager.getService(ElementPresentationManager.class);
    }

    @NotNull
    public <T> Object[] createVariants(Collection<T> elements) {
        Object[] objectArray = this.createVariants(elements, DEFAULT_NAMER);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManager.createVariants must not return null");
        }
        return objectArray;
    }

    @NotNull
    public <T> Object[] createVariants(Collection<T> elements, int iconFlags) {
        Object[] objectArray = this.createVariants(elements, DEFAULT_NAMER, iconFlags);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManager.createVariants must not return null");
        }
        return objectArray;
    }

    @NotNull
    public <T> Object[] createVariants(Collection<T> elements, Function<T, String> namer) {
        Object[] objectArray = this.createVariants(elements, namer, 0);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManager.createVariants must not return null");
        }
        return objectArray;
    }

    public abstract Object createVariant(Object var1, String var2, PsiElement var3);

    @NotNull
    public abstract <T> Object[] createVariants(Collection<T> var1, Function<T, String> var2, int var3);

    public static void registerNameProvider(Function<Object, String> function) {
        ourNameProviders.add(function);
    }

    public static void registerDocumentationProvider(Function<Object, String> function) {
        ourDocumentationProviders.add(function);
    }

    public static void registerIconProvider(Function<Object, Icon> function) {
        ourIconProviders.add(function);
    }

    public static void unregisterNameProvider(Function<Object, String> function) {
        ourNameProviders.remove(function);
    }

    public static void registerIcon(Class aClass, Icon icon) {
        ElementPresentationManager.registerIcons(aClass, icon);
    }

    public static void registerIcons(Class aClass, Icon ... icon) {
        ourIcons.put(aClass, icon);
    }

    @Nullable
    public static String getElementName(Object element) {
        String s;
        for (Function<Object, String> function : ourNameProviders) {
            s = (String)function.fun(element);
            if (s == null) continue;
            return s;
        }
        Object o = ElementPresentationManager.invokeNameValueMethod(element);
        if (o == null || o instanceof String) {
            return (String)o;
        }
        if (o instanceof GenericValue) {
            Object value;
            GenericValue gv = (GenericValue)o;
            s = gv.getStringValue();
            if (s == null && (value = gv.getValue()) != null) {
                return String.valueOf(value);
            }
            return s;
        }
        return null;
    }

    @Nullable
    public static String getDocumentationForElement(Object element) {
        for (Function<Object, String> function : ourDocumentationProviders) {
            String s = (String)function.fun(element);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public static Object invokeNameValueMethod(Object element) {
        Method nameValueMethod = ElementPresentationManager.findNameValueMethod(element.getClass());
        if (nameValueMethod == null) {
            return null;
        }
        return DomReflectionUtil.invokeMethod(nameValueMethod, element, new Object[0]);
    }

    public static String getTypeNameForObject(Object o) {
        Object firstImpl = ModelMergerUtil.getFirstImplementation(o);
        Class<?> aClass = (o = firstImpl != null ? firstImpl : o).getClass();
        String s = TypeNameManager._getTypeName(aClass);
        if (s != null) {
            return s;
        }
        if (o instanceof DomElement) {
            DomElement element = (DomElement)o;
            return StringUtil.capitalizeWords((String)element.getNameStrategy().splitIntoWords(element.getXmlElementName()), (boolean)true);
        }
        return TypeNameManager.getDefaultTypeName(aClass);
    }

    @Nullable
    public static Icon getIcon(Object o) {
        Icon[] icons;
        for (Function<Object, Icon> function : ourIconProviders) {
            Icon icon = (Icon)function.fun(o);
            if (icon == null) continue;
            return icon;
        }
        if (o instanceof DomElement) {
            DomElement domElement = (DomElement)o;
            boolean dumb = DumbService.getInstance(domElement.getManager().getProject()).isDumb();
            for (IconProvider provider : (IconProvider[])IconProvider.EXTENSION_POINT_NAME.getExtensions()) {
                Icon icon;
                if (!(provider instanceof DomIconProvider) || dumb && !(provider instanceof DumbAware) || (icon = ((DomIconProvider)provider).getIcon(domElement, 0)) == null) continue;
                return icon;
            }
        }
        if ((icons = ElementPresentationManager.getIconsForClass(o.getClass())) != null && icons.length > 0) {
            return icons[0];
        }
        return null;
    }

    @Nullable
    public static Icon getIconOld(Object o) {
        for (Function<Object, Icon> function : ourIconProviders) {
            Icon icon = (Icon)function.fun(o);
            if (icon == null) continue;
            return icon;
        }
        Icon[] icons = ElementPresentationManager.getIconsForClass(o.getClass());
        if (icons != null && icons.length > 0) {
            return icons[0];
        }
        return null;
    }

    @Nullable
    private static <T> T getFirst(@Nullable T[] array) {
        return array == null || array.length == 0 ? null : (T)array[0];
    }

    @Nullable
    public static Icon getIconForClass(Class clazz) {
        return ElementPresentationManager.getFirst(ElementPresentationManager.getIconsForClass(clazz));
    }

    @Nullable
    public static Icon[] getIconsForClass(Class clazz) {
        return TypeNameManager.getFromClassMap(ourIcons, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method findNameValueMethod(Class<? extends Object> aClass) {
        ConcurrentFactoryMap<Class, Method> concurrentFactoryMap = ourNameValueMethods;
        synchronized (concurrentFactoryMap) {
            return (Method)ourNameValueMethods.get(aClass);
        }
    }

    @Nullable
    public static <T> T findByName(Collection<T> collection, final String name) {
        return (T)ContainerUtil.find(collection, (Condition)new Condition<T>(){

            public boolean value(T object) {
                return Comparing.equal((String)name, (String)ElementPresentationManager.getElementName(object), (boolean)true);
            }
        });
    }

    static {
        ourIconProviders.add((Function<Object, Icon>)new NullableFunction<Object, Icon>(){

            public Icon fun(Object o) {
                return o instanceof Iconable ? ((Iconable)o).getIcon(2) : null;
            }
        });
        NAMER = new NullableFunction<Object, String>(){

            public String fun(Object o) {
                return ElementPresentationManager.getElementName(o);
            }
        };
    }
}

