/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NonNls
    private static final String CLONE_METHOD_NAME = "clone";

    private ExceptionUtil() {
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not be null");
        }
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getThrownCheckedExceptions(@NotNull PsiElement[] elements) {
        List<PsiClassType> list;
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownCheckedExceptions must not be null");
        }
        List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(elements);
        if (exceptions.isEmpty()) {
            list = exceptions;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownCheckedExceptions must not return null");
            return list;
        }
        list = exceptions = ExceptionUtil.filterOutUncheckedExceptions(exceptions);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownCheckedExceptions must not return null");
    }

    @NotNull
    private static List<PsiClassType> filterOutUncheckedExceptions(List<PsiClassType> exceptions) {
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isUncheckedException(exception)) continue;
            array.add(exception);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.filterOutUncheckedExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static List<PsiClassType> getThrownExceptions(@NotNull PsiElement element) {
        PsiCodeBlock[] catchBlocks;
        PsiParameter[] parameters;
        List<Object> list;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not be null");
        }
        if (element instanceof PsiClass) {
            PsiExpressionList argumentList;
            if (!(element instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)element).getArgumentList()) != null ? (list = ExceptionUtil.getThrownExceptions((PsiElement)argumentList)) != null : (list = Collections.emptyList()) != null)) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodRef = ((PsiMethodCallExpression)element).getMethodExpression();
            JavaResolveResult result = methodRef.advancedResolve(false);
            list = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result = ((PsiNewExpression)element).resolveMethodGenerics();
            list = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiThrowStatement) {
            PsiExpression expr = ((PsiThrowStatement)element).getException();
            if (expr == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
                return list;
            } else {
                PsiType exception = expr.getType();
                ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
                if (exception instanceof PsiClassType) {
                    array.add((PsiClassType)exception);
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)expr));
                list = array;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
                return list;
            }
        }
        if (!(element instanceof PsiTryStatement)) {
            list = ExceptionUtil.getThrownExceptions(element.getChildren());
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)element;
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        if (tryBlock != null) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions((PsiElement)tryBlock);
            array.addAll(exceptions);
        }
        for (PsiParameter parm : parameters = tryStatement.getCatchBlockParameters()) {
            PsiType exception = parm.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom((PsiType)exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)catchBlock));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> thrownExceptions = ExceptionUtil.getThrownExceptions((PsiElement)finallyBlock);
                if ((completionReasons & 1) == 0) {
                    array = new ArrayList<PsiClassType>(thrownExceptions);
                } else {
                    ExceptionUtil.addExceptions(array, thrownExceptions);
                }
            }
            catch (AnalysisCanceledException e) {
                // empty catch block
            }
        }
        if ((list = array) == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
        return list;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(PsiElement element, JavaResolveResult resolveResult) {
        PsiElement[] children;
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        if (method != null) {
            PsiClassType[] referenceTypes;
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiClassType type : referenceTypes = method.getThrowsList().getReferencedTypes()) {
                if (!((type = substitutor.substitute((PsiType)type)) instanceof PsiClassType)) continue;
                result.add(type);
            }
        }
        for (PsiElement child : children = element.getChildren()) {
            ExceptionUtil.addExceptions(result, ExceptionUtil.getThrownExceptions(child));
        }
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getExceptionsByMethodAndChildren must not return null");
        }
        return arrayList;
    }

    private static void addExceptions(List<PsiClassType> array, Collection<PsiClassType> exceptions) {
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(List<PsiClassType> array, PsiClassType exception) {
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom((PsiType)exception)) {
                return;
            }
            if (!exception.isAssignableFrom((PsiType)exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, PsiElement topElement) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not be null");
        }
        Set<PsiClassType> set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null);
        Collection<Object> collection = set == null ? Collections.emptyList() : set;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not return null");
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, PsiElement topElement, Set<PsiClassType> foundExceptions) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not be null");
        }
        Collection<Object> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression, topElement);
        } else if (element instanceof PsiThrowStatement) {
            PsiThrowStatement statement = (PsiThrowStatement)element;
            PsiClassType exception = ExceptionUtil.getUnhandledException(statement, topElement);
            unhandledExceptions = exception == null ? Collections.emptyList() : Collections.singletonList(exception);
        } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
            PsiMethod constructor = (PsiMethod)element.getParent();
            PsiClass aClass = constructor.getContainingClass();
            PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
            PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
            HashSet<PsiClassType> unhandled = new HashSet<PsiClassType>();
            for (PsiMethod superConstructor : superConstructors) {
                PsiClassType[] exceptionTypes;
                if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                    if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                    unhandled.add(exceptionType);
                }
                break;
            }
            if (aClass != null) {
                PsiClassInitializer[] initializers = aClass.getInitializers();
                THashSet thrownByInitializer = new THashSet();
                for (PsiClassInitializer initializer : initializers) {
                    if (initializer.hasModifierProperty("static")) continue;
                    thrownByInitializer.clear();
                    ExceptionUtil.collectUnhandledExceptions((PsiElement)initializer.getBody(), (PsiElement)initializer, (Set<PsiClassType>)thrownByInitializer);
                    for (PsiClassType thrown : thrownByInitializer) {
                        if (ExceptionUtil.isHandled((PsiElement)constructor.getBody(), thrown, topElement)) continue;
                        unhandled.add(thrown);
                    }
                }
            }
            unhandledExceptions = unhandled;
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            foundExceptions = ExceptionUtil.collectUnhandledExceptions(child, topElement, (Set<PsiClassType>)foundExceptions);
        }
        return foundExceptions;
    }

    private static boolean firstStatementIsConstructorCall(PsiCodeBlock constructorBody) {
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiElement[] elements) {
        final ArrayList<PsiClassType> array = new ArrayList<PsiClassType>();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitCallExpression(PsiCallExpression expression) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement((PsiElement)expression);
            }

            public void visitThrowStatement(PsiThrowStatement statement) {
                ExceptionUtil.addException(array, ExceptionUtil.getUnhandledException(statement, null));
                this.visitElement((PsiElement)statement);
            }
        };
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)visitor);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiElement element) {
        PsiThrowStatement throwStatement;
        PsiClassType exception;
        List<Object> list;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            list = ExceptionUtil.getUnhandledExceptions(expression, null);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        if (element instanceof PsiThrowStatement && (exception = ExceptionUtil.getUnhandledException(throwStatement = (PsiThrowStatement)element, null)) != null) {
            list = Collections.singletonList(exception);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiCallExpression methodCall, PsiElement topElement) {
        final JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, (PsiSubstitutor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiSubstitutor>(){

            public PsiSubstitutor compute() {
                return result.getSubstitutor();
            }
        }));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return list;
    }

    @Nullable
    public static PsiClassType getUnhandledException(PsiThrowStatement throwStatement, PsiElement topElement) {
        PsiClassType classType;
        PsiType type;
        PsiExpression exception = throwStatement.getException();
        if (exception != null && (type = exception.getType()) instanceof PsiClassType && !ExceptionUtil.isUncheckedException(classType = (PsiClassType)type) && !ExceptionUtil.isHandled((PsiElement)throwStatement, classType, topElement)) {
            return classType;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(PsiMethod method, PsiElement element, PsiElement topElement, PsiSubstitutor substitutor) {
        List<Object> list;
        if (method == null || ExceptionUtil.isArrayClone(method, element)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        } else {
            PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
            if (referencedTypes.length <= 0) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
                return list;
            } else {
                ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
                for (PsiClassType referencedType : referencedTypes) {
                    PsiType type = substitutor.substitute((PsiType)referencedType);
                    if (!(type instanceof PsiClassType)) continue;
                    PsiClassType classType = (PsiClassType)type;
                    PsiClass exceptionClass = ((PsiClassType)type).resolve();
                    if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                    result.add((PsiClassType)type);
                }
                list = result;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
                return list;
            }
        }
    }

    private static boolean isArrayClone(PsiMethod method, PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (!method.getName().equals(CLONE_METHOD_NAME)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(PsiClassType type) {
        final GlobalSearchScope searchScope = type.getResolveScope();
        final PsiClass aClass = type.resolve();
        if (aClass == null) {
            return false;
        }
        PsiClass runtimeExceptionClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.RuntimeException", searchScope);
            }
        });
        if (runtimeExceptionClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)runtimeExceptionClass, (boolean)true)) {
            return true;
        }
        PsiClass errorClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Error", searchScope);
            }
        });
        return errorClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)errorClass, (boolean)true);
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isUncheckedExceptionOrSuperclass must not be null");
        }
        String canonicalText = type.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText) || ExceptionUtil.isUncheckedException(type);
    }

    public static boolean isHandled(PsiClassType exceptionType, PsiElement throwPlace) {
        return ExceptionUtil.isHandled(throwPlace, exceptionType, (PsiElement)throwPlace.getContainingFile());
    }

    private static boolean isHandled(PsiElement element, PsiClassType exceptionType, PsiElement topElement) {
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        } else if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCatched(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            PsiClass aClass;
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (JspPsiUtil.isInJspFile((PsiElement)parent) && parent instanceof PsiFile) {
                return true;
            }
            if (parent instanceof PsiFile) {
                return false;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element && (aClass = ((PsiField)parent).getContainingClass()) != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        }
        return ExceptionUtil.isHandled(parent, exceptionType, topElement);
    }

    private static boolean areAllConstructorsThrow(PsiClass aClass, PsiClassType exceptionType) {
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCatched(PsiTryStatement tryStatement, PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions((PsiElement)finallyBlock);
            if (exceptions.contains(exceptionType)) {
                return false;
            }
            if (ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(PsiCodeBlock finallyBlock) {
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if ((completionReasons & 1) == 0) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(PsiMethod method, PsiClassType exceptionType) {
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes);
    }

    public static boolean isHandledBy(PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        if (referencedTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isHandledBy must not be null");
        }
        for (PsiClassType classType : referencedTypes) {
            if (!classType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void sortExceptionsByHierarchy(List<PsiClassType> exceptions) {
        if (exceptions.size() <= 1) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(exceptions.subList(1, exceptions.size()));
        for (int i = 0; i < exceptions.size() - 1; ++i) {
            if (!TypeConversionUtil.isAssignable((PsiType)((PsiType)exceptions.get(i)), (PsiType)((PsiType)exceptions.get(i + 1)))) continue;
            Collections.swap(exceptions, i, i + 1);
        }
    }
}

