/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.editorActions.XmlAutoPopupHandler;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;

public class XmlCharFilter
extends CharFilter {
    public static boolean isInXmlContext(Lookup lookup) {
        if (!lookup.isCompletion()) {
            return false;
        }
        PsiElement psiElement = lookup.getPsiElement();
        PsiFile file = lookup.getPsiFile();
        if (!(file instanceof XmlFile) && psiElement != null) {
            file = psiElement.getContainingFile();
        }
        if (file instanceof XmlFile) {
            if (psiElement != null) {
                Language language;
                PsiElement elementToTest = psiElement;
                if (elementToTest instanceof PsiWhiteSpace) {
                    elementToTest = elementToTest.getParent();
                }
                if (!((language = elementToTest.getLanguage()) instanceof XMLLanguage)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isWithinTag(Lookup lookup) {
        if (XmlCharFilter.isInXmlContext(lookup)) {
            String s;
            PsiElement psiElement = lookup.getPsiElement();
            PsiElement parentElement = psiElement.getParent() != null ? psiElement.getParent() : null;
            return parentElement != null && (parentElement instanceof XmlTag || parentElement instanceof PsiErrorElement && parentElement.getParent() instanceof XmlDocument || (parentElement instanceof XmlDocument || parentElement instanceof XmlText) && ((s = psiElement.getText()).equals("<") || s.equals("\"")));
        }
        return false;
    }

    @Override
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
        if (!XmlCharFilter.isInXmlContext(lookup)) {
            return null;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        switch (c) {
            case '-': {
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            case '/': {
                if (XmlCharFilter.isWithinTag(lookup)) {
                    if (prefixLength > 0) {
                        return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                    }
                    XmlAutoPopupHandler.autoPopupXmlLookup(lookup.getEditor().getProject(), lookup.getEditor());
                    return CharFilter.Result.HIDE_LOOKUP;
                }
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            case '>': {
                if (prefixLength > 0) {
                    return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
            }
            case '\"': 
            case '\'': {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
        }
        return null;
    }
}

