/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddNewArrayExpressionFix
implements IntentionAction {
    private final PsiArrayInitializerExpression myInitializer;

    public AddNewArrayExpressionFix(PsiArrayInitializerExpression initializer) {
        this.myInitializer = initializer;
    }

    @NotNull
    public String getText() {
        PsiExpression expr = this.myInitializer.getInitializers()[0];
        PsiType type = expr.getType();
        String string = QuickFixBundle.message("add.new.array.text", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddNewArrayExpressionFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.new.array.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddNewArrayExpressionFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddNewArrayExpressionFix.isAvailable must not be null");
        }
        if (!this.myInitializer.isValid() || !this.myInitializer.getManager().isInProject((PsiElement)this.myInitializer)) {
            return false;
        }
        PsiExpression[] initializers = this.myInitializer.getInitializers();
        return initializers.length > 0 && initializers[0].getType() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddNewArrayExpressionFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.preparePsiElementsForWrite(new PsiElement[]{this.myInitializer, file})) {
            return;
        }
        PsiManager manager = file.getManager();
        PsiExpression expr = this.myInitializer.getInitializers()[0];
        PsiType type = expr.getType();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String text = "new " + type.getPresentableText() + "[]{}";
        PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText(text, null);
        newExpr.getArrayInitializer().replace((PsiElement)this.myInitializer);
        newExpr = (PsiNewExpression)manager.getCodeStyleManager().reformat((PsiElement)newExpr);
        this.myInitializer.replace((PsiElement)newExpr);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

