/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;

public class EnterAfterUnmatchedBraceHandler
implements EnterHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler");

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, Ref<Integer> caretOffsetRef, Ref<Integer> caretAdvance, DataContext dataContext, EditorActionHandler originalHandler) {
        Document document = editor.getDocument();
        String text = document.getText();
        Project project = file.getProject();
        int caretOffset = (Integer)caretOffsetRef.get();
        if (CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER && EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor, caretOffset, file.getFileType())) {
            char c;
            int offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t");
            if (offset < document.getTextLength() && (c = text.charAt(offset)) != ')' && c != ']' && c != ';' && c != ',' && c != '%' && c != '<') {
                offset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)caretOffset, (String)"\n");
            }
            offset = Math.min(offset, document.getTextLength());
            document.insertString(offset, (CharSequence)"\n}");
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            try {
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset + 1);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public static boolean isAfterUnmatchedLBrace(Editor editor, int offset, FileType fileType) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '{') {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (!braceMatcher.isLBraceToken(iterator, chars, fileType) || !braceMatcher.isStructuralBrace(iterator, chars, fileType)) {
            return false;
        }
        Language language = iterator.getTokenType().getLanguage();
        iterator = highlighter.createIterator(0);
        int balance = 0;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType.getLanguage().equals(language) && braceMatcher.isStructuralBrace(iterator, chars, fileType)) {
                if (braceMatcher.isLBraceToken(iterator, chars, fileType)) {
                    ++balance;
                } else if (braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                    --balance;
                }
            }
            iterator.advance();
        }
        return balance > 0;
    }
}

