/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateGetterAndSetterHandler;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenerateFieldOrPropertyHandler
extends GenerateMembersHandlerBase {
    private final String myAttributeName;
    private final PsiType myType;
    private final PropertyMemberType myMemberType;
    private final PsiAnnotation[] myAnnotations;

    public GenerateFieldOrPropertyHandler(String attributeName, PsiType type, PropertyMemberType memberType, PsiAnnotation ... annotations) {
        super("");
        this.myAttributeName = attributeName;
        this.myType = type;
        this.myMemberType = memberType;
        this.myAnnotations = annotations;
    }

    @Override
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        return ClassMember.EMPTY_ARRAY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        List<Object> list;
        List<GenerationInfo> list2;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        try {
            String name = this.myMemberType == PropertyMemberType.FIELD ? this.myAttributeName : JavaCodeStyleManager.getInstance((Project)aClass.getProject()).propertyNameToVariableName(this.myAttributeName, VariableKind.FIELD);
            PsiField psiField = psiElementFactory.createField(name, this.myType);
            GenerationInfo[] objects = new GenerateGetterAndSetterHandler().generateMemberPrototypes(aClass, new PsiFieldMember(psiField));
            GenerationInfo getter = objects[0];
            GenerationInfo setter = objects[1];
            if (this.myAnnotations.length > 0) {
                PsiField targetMember;
                switch (this.myMemberType) {
                    case FIELD: {
                        targetMember = psiField;
                        break;
                    }
                    case GETTER: {
                        targetMember = getter.getPsiMember();
                        break;
                    }
                    case SETTER: {
                        targetMember = setter.getPsiMember();
                        break;
                    }
                    default: {
                        targetMember = null;
                    }
                }
                assert (targetMember != null);
                for (PsiAnnotation annotation : this.myAnnotations) {
                    targetMember.getModifierList().addAfter((PsiElement)annotation, null);
                }
            }
            list2 = Arrays.asList(new PsiGenerationInfo<PsiField>(psiField), getter, setter);
        }
        catch (IncorrectOperationException e) {
            assert (false) : e;
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler.generateMemberPrototypes must not return null");
            return list;
        }
        list = list2;
        if (list2 == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler.generateMemberPrototypes must not return null");
        return list;
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }
}

