/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;

public class SimpleFieldChooser
extends DialogWrapper {
    private final PsiField[] myFields;
    private JList myList;

    public SimpleFieldChooser(PsiField[] members, Project project) {
        super(project, true);
        this.myFields = members;
        this.init();
    }

    protected JComponent createCenterPanel() {
        DefaultListModel<PsiField> model = new DefaultListModel<PsiField>();
        for (PsiField member : this.myFields) {
            model.addElement(member);
        }
        this.myList = new JList(model);
        this.myList.setCellRenderer(new MyListCellRenderer());
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SimpleFieldChooser.this.myList.getSelectedValues().length > 0) {
                    SimpleFieldChooser.this.doOKAction();
                }
            }
        });
        this.myList.setPreferredSize(new Dimension(300, 400));
        return this.myList;
    }

    public Object[] getSelectedElements() {
        return this.myList.getSelectedValues();
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon = null;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PsiField) {
                PsiField field = (PsiField)value;
                icon = field.getIcon(0);
                String text = PsiFormatUtil.formatVariable((PsiVariable)field, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                this.setText(text);
            }
            super.setIcon(icon);
            return this;
        }
    }
}

