/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class TypedHandler
implements TypedActionHandler {
    private final TypedActionHandler myOriginalHandler;

    public TypedHandler(TypedActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void execute(final @NotNull Editor editor, final char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/TypedHandler.execute must not be null");
        }
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/TypedHandler.execute must not be null");
        }
        final LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (lookup == null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
            return;
        }
        LookupElement currentItem = lookup.getCurrentItem();
        final CharFilter.Result result = TypedHandler.getLookupAction(charTyped, currentItem, lookup);
        CommandProcessor.getInstance().executeCommand((Project)PlatformDataKeys.PROJECT.getData(dataContext), new Runnable(){

            @Override
            public void run() {
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                if (result == CharFilter.Result.ADD_TO_PREFIX) {
                    lookup.setAdditionalPrefix(lookup.getAdditionalPrefix() + charTyped);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(charTyped));
                }
            }
        }, "", (Object)editor.getDocument());
        if (result == CharFilter.Result.ADD_TO_PREFIX) {
            lookup.refreshUi();
        } else {
            LookupElement item;
            if (result == CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP && (item = lookup.getCurrentItem()) != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByDotEtc");
                lookup.finishLookup(charTyped);
                return;
            }
            lookup.hide();
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
    }

    private static CharFilter.Result getLookupAction(char charTyped, LookupElement currentItem, LookupImpl lookup) {
        Object[] filters;
        if (currentItem != null && charTyped != ' ') {
            String postfix = lookup.getAdditionalPrefix() + charTyped;
            PrefixMatcher matcher = currentItem.getPrefixMatcher();
            if (matcher.cloneWithPrefix(matcher.getPrefix() + postfix).prefixMatches(currentItem)) {
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            for (LookupElement element : lookup.getItems()) {
                if (!element.isPrefixMatched() || !element.getPrefixMatcher().cloneWithPrefix(element.getPrefixMatcher().getPrefix() + postfix).prefixMatches(element)) continue;
                return CharFilter.Result.ADD_TO_PREFIX;
            }
        }
        for (CharFilter charFilter : filters = (CharFilter[])Extensions.getExtensions(CharFilter.EP_NAME)) {
            CharFilter.Result result = charFilter.acceptChar(charTyped, lookup.getMinPrefixLength() + lookup.getAdditionalPrefix().length(), lookup);
            if (result == null) continue;
            return result;
        }
        throw new AssertionError((Object)("Typed char not handler by char filter: c=" + charTyped + "; prefix=" + currentItem + "; filters=" + Arrays.toString(filters)));
    }
}

