/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.PsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTDelegatePsiElement
extends PsiElementBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.extapi.psi.ASTDelegatePsiElement");
    private static final List EMPTY = Collections.emptyList();

    @Override
    public PsiManagerEx getManager() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return (PsiManagerEx)parent.getManager();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            psiElementArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.getChildren must not return null");
            return psiElementArray;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (psiChild.getNode() instanceof CompositeElement) {
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        psiElementArray = result.toArray(new PsiElement[result.size()]);
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.getChildren must not return null");
    }

    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this.getNode());
    }

    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this.getNode());
    }

    public TextRange getTextRange() {
        return this.getNode().getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.getNode().getStartOffset() - this.getNode().getTreeParent().getStartOffset();
    }

    public int getTextLength() {
        return this.getNode().getTextLength();
    }

    public PsiElement findElementAt(int offset) {
        ASTNode treeElement = this.getNode().findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(treeElement);
    }

    public int getTextOffset() {
        return this.getNode().getStartOffset();
    }

    public String getText() {
        return this.getNode().getText();
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getNode().getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.textToCharArray must not return null");
        }
        return cArray;
    }

    public boolean textContains(char c) {
        return this.getNode().textContains(c);
    }

    public <T> T getCopyableUserData(Key<T> key) {
        return (T)this.getNode().getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.getNode().putCopyableUserData(key, value);
    }

    @NotNull
    public abstract ASTNode getNode();

    public void subtreeChanged() {
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getNode().getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/ASTDelegatePsiElement.getLanguage must not return null");
        }
        return language;
    }

    @Nullable
    protected PsiElement findChildByType(IElementType type) {
        ASTNode node = this.getNode().findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    protected PsiElement findChildByType(TokenSet type) {
        ASTNode node = this.getNode().findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    protected PsiElement findChildByFilter(TokenSet tokenSet) {
        ASTNode[] nodes = this.getNode().getChildren(tokenSet);
        return nodes == null || nodes.length == 0 ? null : nodes[0].getPsi();
    }

    protected <T extends PsiElement> T[] findChildrenByType(IElementType elementType, Class<T> arrayClass) {
        return (PsiElement[])ContainerUtil.map2Array((Object[])SharedImplUtil.getChildrenOfType(this.getNode(), elementType), arrayClass, (Function)new Function<ASTNode, T>(){

            public T fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    protected <T extends PsiElement> List<T> findChildrenByType(TokenSet elementType) {
        ArrayList<PsiElement> result = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!elementType.contains(tt)) continue;
            if (result == EMPTY) {
                result = new ArrayList<PsiElement>();
            }
            result.add(child.getPsi());
        }
        return result;
    }

    protected <T extends PsiElement> List<T> findChildrenByType(IElementType elementType) {
        ArrayList<PsiElement> result = EMPTY;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (elementType != child.getElementType()) continue;
            if (result == EMPTY) {
                result = new ArrayList<PsiElement>();
            }
            result.add(child.getPsi());
        }
        return result;
    }

    protected <T extends PsiElement> T[] findChildrenByType(TokenSet elementType, Class<T> arrayClass) {
        return (PsiElement[])ContainerUtil.map2Array((Object[])this.getNode().getChildren(elementType), arrayClass, (Function)new Function<ASTNode, PsiElement>(){

            public PsiElement fun(ASTNode s) {
                return s.getPsi();
            }
        });
    }

    @Override
    public PsiElement copy() {
        return this.getNode().copyElement().getPsi();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.add must not be null");
        }
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addBefore must not be null");
        }
        return this.addInnerBefore(element, anchor);
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            if (treeElement instanceof TreeElement) {
                return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
            }
            return treeElement.getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addAfter must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        ASTNode treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        if (treeElement instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)treeElement).getPsi();
        }
        return treeElement.getPsi();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.checkAdd must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        return CodeEditUtil.addChildren(this.getNode(), first, last, this.getAnchorNode(anchor, before));
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addRangeBefore must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.addRangeBefore must not be null");
        }
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((ASTDelegatePsiElement)this.getParent()).deleteChildInternal(this.getNode());
        } else if (this.getParent() instanceof PsiFile) {
            CheckUtil.checkWritable((PsiElement)this);
            this.getParent().deleteChildRange((PsiElement)this, (PsiElement)this);
        } else {
            super.delete();
        }
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.deleteChildInternal must not be null");
        }
        CodeEditUtil.removeChild(this.getNode(), child);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this.getNode());
        LOG.assertTrue(lastElement.getTreeParent() == this.getNode());
        CodeEditUtil.removeChildren(this.getNode(), firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/ASTDelegatePsiElement.replace must not be null");
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            ASTDelegatePsiElement parentElement = (ASTDelegatePsiElement)this.getParent();
            parentElement.replaceChildInternal((PsiElement)this, elementCopy);
        } else {
            CodeEditUtil.replaceChild(this.getParent().getNode(), this.getNode(), elementCopy);
        }
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public void replaceChildInternal(PsiElement child, TreeElement newElement) {
        CodeEditUtil.replaceChild(this.getNode(), child.getNode(), newElement);
    }

    private ASTNode getAnchorNode(ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before != null && before == false ? this.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }
}

