/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageView;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiElement2UsageTargetAdapter
implements PsiElementUsageTarget,
TypeSafeDataProvider {
    private final SmartPsiElementPointer myPointer;
    private final MyItemPresentation myPresentation;

    public PsiElement2UsageTargetAdapter(PsiElement element) {
        this.myPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        if (!(element instanceof NavigationItem)) {
            throw new IllegalArgumentException("Element is not a navigation item: " + element);
        }
        this.myPresentation = new MyItemPresentation();
    }

    public String getName() {
        return this.getNavigationItem().getName();
    }

    public ItemPresentation getPresentation() {
        return this.myPresentation;
    }

    public void navigate(boolean requestFocus) {
        if (!this.canNavigate()) {
            return;
        }
        this.getNavigationItem().navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.isValid() && this.getNavigationItem().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.isValid() && this.getNavigationItem().canNavigateToSource();
    }

    private NavigationItem getNavigationItem() {
        return (NavigationItem)this.getElement();
    }

    public FileStatus getFileStatus() {
        return this.isValid() ? this.getNavigationItem().getFileStatus() : FileStatus.NOT_CHANGED;
    }

    public String toString() {
        return this.myPresentation.getPresentableText();
    }

    public void findUsages() {
        PsiElement element = this.getElement();
        FindManager.getInstance((Project)element.getProject()).findUsages(element);
    }

    public PsiElement getElement() {
        return this.myPointer.getElement();
    }

    public void findUsagesInEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/PsiElement2UsageTargetAdapter.findUsagesInEditor must not be null");
        }
        PsiElement element = this.getElement();
        FindManager.getInstance((Project)element.getProject()).findUsagesInEditor(element, editor);
    }

    public void highlightUsages(PsiFile file, Editor editor, boolean clearHighlights) {
        PsiElement target = this.getElement();
        if (file instanceof PsiCompiledElement) {
            file = (PsiFile)((PsiCompiledElement)file).getMirror();
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)target.getProject())).getFindUsagesManager();
        FindUsagesHandler handler = findUsagesManager.getFindUsagesHandler(target, true);
        PsiFile context = InjectedLanguageUtil.getTopLevelFile((PsiElement)file);
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)context);
        Collection refs = handler != null ? handler.findReferencesToHighlight(target, (SearchScope)searchScope) : ReferencesSearch.search((PsiElement)target, (SearchScope)searchScope, (boolean)false).findAll();
        new HighlightUsagesHandler.DoHighlightRunnable(new ArrayList<PsiReference>(refs), target.getProject(), target, editor, context, clearHighlights).run();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    public boolean isReadOnly() {
        return this.isValid() && !this.getElement().isWritable();
    }

    public VirtualFile[] getFiles() {
        VirtualFile[] virtualFileArray;
        if (!this.isValid()) {
            return null;
        }
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFileArray = null;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = virtualFile;
        }
        return virtualFileArray;
    }

    public void update() {
        this.myPresentation.update();
    }

    public static PsiElement2UsageTargetAdapter[] convert(PsiElement[] psiElements) {
        PsiElement2UsageTargetAdapter[] targets = new PsiElement2UsageTargetAdapter[psiElements.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new PsiElement2UsageTargetAdapter(psiElements[i]);
        }
        return targets;
    }

    public void calcData(DataKey key, DataSink sink) {
        PsiElement element;
        if (key == UsageView.USAGE_INFO_KEY && (element = this.getElement()) != null && element.getTextRange() != null) {
            sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo(element));
        }
    }

    private class MyItemPresentation
    implements ItemPresentation {
        private String myPresentableText;
        private Icon myIconOpen;
        private Icon myIconClosed;

        public MyItemPresentation() {
            this.update();
        }

        public void update() {
            PsiElement element = PsiElement2UsageTargetAdapter.this.getElement();
            if (element != null) {
                ItemPresentation presentation = ((NavigationItem)element).getPresentation();
                this.myIconOpen = presentation != null ? presentation.getIcon(true) : null;
                this.myIconClosed = presentation != null ? presentation.getIcon(false) : null;
                this.myPresentableText = UsageViewUtil.createNodeText(element);
                if (this.myIconOpen == null || this.myIconClosed == null) {
                    PsiFile psiFile;
                    VirtualFile virtualFile;
                    if (element instanceof PsiMetaOwner) {
                        PsiMetaOwner psiMetaOwner = (PsiMetaOwner)element;
                        PsiMetaData metaData = psiMetaOwner.getMetaData();
                        if (metaData instanceof PsiPresentableMetaData) {
                            PsiPresentableMetaData psiPresentableMetaData = (PsiPresentableMetaData)metaData;
                            if (this.myIconOpen == null) {
                                this.myIconOpen = psiPresentableMetaData.getIcon();
                            }
                            if (this.myIconClosed == null) {
                                this.myIconClosed = psiPresentableMetaData.getIcon();
                            }
                        }
                    } else if (element instanceof PsiFile && (virtualFile = (psiFile = (PsiFile)element).getVirtualFile()) != null) {
                        this.myIconOpen = virtualFile.getIcon();
                        this.myIconClosed = virtualFile.getIcon();
                    }
                }
            }
        }

        public String getPresentableText() {
            return this.myPresentableText;
        }

        public String getLocationString() {
            return null;
        }

        public TextAttributesKey getTextAttributesKey() {
            return null;
        }

        public Icon getIcon(boolean open) {
            return open ? this.myIconOpen : this.myIconClosed;
        }
    }
}

