/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.storage;

import com.intellij.history.core.storage.BrokenStorageException;
import com.intellij.history.core.storage.IContentStorage;
import com.intellij.util.containers.IntObjectCache;

public class CachingContentStorage
implements IContentStorage {
    public static final int MAX_CACHED_CONTENT_LENGTH = 102400;
    private final IContentStorage mySubject;
    private final IntObjectCache<byte[]> myCache = new IntObjectCache(50);

    public CachingContentStorage(IContentStorage s) {
        this.mySubject = s;
    }

    @Override
    public void save() {
        this.mySubject.save();
    }

    @Override
    public void close() {
        this.mySubject.close();
    }

    @Override
    public int store(byte[] content) throws BrokenStorageException {
        int id = this.mySubject.store(content);
        this.cacheContent(content, id);
        return id;
    }

    @Override
    public byte[] load(int id) throws BrokenStorageException {
        byte[] result = this.findInCache(id);
        if (result != null) {
            return result;
        }
        result = this.mySubject.load(id);
        this.cacheContent(result, id);
        return result;
    }

    private byte[] findInCache(int id) {
        return (byte[])this.myCache.tryKey(id);
    }

    @Override
    public void remove(int id) {
        this.mySubject.remove(id);
        this.myCache.remove(id);
    }

    @Override
    public void setVersion(int version) {
        this.mySubject.setVersion(version);
    }

    @Override
    public int getVersion() {
        return this.mySubject.getVersion();
    }

    private void cacheContent(byte[] content, int id) {
        if (content.length > 102400) {
            return;
        }
        this.myCache.cacheObject(id, (Object)content);
    }
}

