/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoFileConfiguration;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GotoFileAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void gotoActionPerformed(AnActionEvent e) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file");
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        GotoFileModel gotoFileModel = new GotoFileModel(project);
        final ChooseByNamePopup popup = ChooseByNamePopup.createPopup(project, gotoFileModel, GotoFileAction.getPsiContext(e));
        final FilterUI filterUI = new FilterUI(popup, gotoFileModel, project);
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
                if (GotoFileAction.class.equals((Object)GotoActionBase.myInAction)) {
                    GotoActionBase.myInAction = null;
                }
                filterUI.close();
            }

            public void elementChosen(Object element) {
                final PsiFile file = (PsiFile)element;
                if (file == null) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file.getVirtualFile(), popup.getLinePosition(), popup.getColumnPosition());
                        if (descriptor.canNavigate()) {
                            descriptor.navigate(true);
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        }, ModalityState.current(), true);
    }

    private static class FilterUI {
        private static final Icon FILTER_ICON = IconLoader.getIcon((String)"/icons/inspector/useFilter.png");
        final ChooseByNamePopup myParentPopup;
        final ActionToolbar myToolbar;
        final ElementsChooser<FileType> myChooser;
        final JPanel myChooserPanel;
        JBPopup myPopup;
        final Project myProject;

        FilterUI(ChooseByNamePopup popup, GotoFileModel gotoFileModel, Project project) {
            this.myParentPopup = popup;
            DefaultActionGroup actionGroup = new DefaultActionGroup("go.to.file.filter", false);
            ToggleAction action = new ToggleAction("Filter", "Filter files by type", FILTER_ICON){

                public boolean isSelected(AnActionEvent e) {
                    return FilterUI.this.myPopup != null;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    if (state) {
                        FilterUI.this.createPopup();
                    } else {
                        FilterUI.this.close();
                    }
                }
            };
            actionGroup.add((AnAction)action);
            this.myToolbar = ActionManager.getInstance().createActionToolbar("gotfile.filter", (ActionGroup)actionGroup, true);
            this.myToolbar.getComponent().setFocusable(false);
            this.myProject = project;
            this.myChooser = this.createFileTypeChooser(gotoFileModel);
            this.myChooserPanel = this.createChooserPanel();
            popup.setToolArea(this.myToolbar.getComponent());
        }

        private JPanel createChooserPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(this.myChooser);
            JPanel buttons = new JPanel();
            JButton all = new JButton("All");
            all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterUI.this.myChooser.setAllElementsMarked(true);
                }
            });
            buttons.add(all);
            JButton none = new JButton("None");
            none.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterUI.this.myChooser.setAllElementsMarked(false);
                }
            });
            buttons.add(none);
            JButton invert = new JButton("Invert");
            invert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int count = FilterUI.this.myChooser.getElementCount();
                    for (int i = 0; i < count; ++i) {
                        FileType type = FilterUI.this.myChooser.getElementAt(i);
                        FilterUI.this.myChooser.setElementMarked(type, !FilterUI.this.myChooser.isElementMarked(type));
                    }
                }
            });
            buttons.add(invert);
            panel.add(buttons);
            return panel;
        }

        private ElementsChooser<FileType> createFileTypeChooser(final GotoFileModel gotoFileModel) {
            ArrayList<FileType> elements = new ArrayList<FileType>();
            elements.addAll(Arrays.asList(FileTypeManager.getInstance().getRegisteredFileTypes()));
            Collections.sort(elements, FileTypeComparator.INSTANCE);
            final ElementsChooser<FileType> chooser = new ElementsChooser<FileType>(elements, true){

                @Override
                protected String getItemText(@NotNull FileType value) {
                    if (value == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/GotoFileAction$FilterUI$5.getItemText must not be null");
                    }
                    return value.getName();
                }

                @Override
                protected Icon getItemIcon(FileType value) {
                    return value.getIcon();
                }
            };
            chooser.setFocusable(false);
            final GotoFileConfiguration config = GotoFileConfiguration.getInstance(this.myProject);
            int count = chooser.getElementCount();
            for (int i = 0; i < count; ++i) {
                FileType type = (FileType)chooser.getElementAt(i);
                if (DumbService.getInstance((Project)this.myProject).isDumb() || config.isFileTypeVisible(type)) continue;
                chooser.setElementMarked(type, false);
            }
            this.updateModel(gotoFileModel, chooser);
            chooser.addElementsMarkListener(new ElementsChooser.ElementsMarkListener<FileType>(){

                @Override
                public void elementMarkChanged(FileType element, boolean isMarked) {
                    config.setFileTypeVisible(element, isMarked);
                    FilterUI.this.updateModel(gotoFileModel, chooser);
                }
            });
            return chooser;
        }

        private void updateModel(GotoFileModel gotoFileModel, ElementsChooser<FileType> chooser) {
            List<FileType> markedElements = chooser.getMarkedElements();
            gotoFileModel.setFileTypes(markedElements.toArray(new FileType[markedElements.size()]));
            this.myParentPopup.rebuildList();
        }

        private void createPopup() {
            if (this.myPopup != null) {
                return;
            }
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myChooserPanel, this.myChooser).setModalContext(false).setFocusable(false).setResizable(true).setCancelOnClickOutside(false).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(this.myProject, "GotoFile_FileTypePopup", false).createPopup();
            this.myPopup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

                public void onClosed(LightweightWindowEvent event) {
                    FilterUI.this.myPopup = null;
                }
            });
            this.myPopup.showUnderneathOf((Component)this.myToolbar.getComponent());
        }

        public void close() {
            if (this.myPopup != null) {
                this.myPopup.dispose();
            }
        }

        static class FileTypeComparator
        implements Comparator<FileType> {
            static final Comparator<FileType> INSTANCE = new FileTypeComparator();

            FileTypeComparator() {
            }

            @Override
            public int compare(FileType o1, FileType o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == FileTypes.UNKNOWN) {
                    return 1;
                }
                if (o2 == FileTypes.UNKNOWN) {
                    return -1;
                }
                if (o1.isBinary() && !o2.isBinary()) {
                    return 1;
                }
                if (!o1.isBinary() && o2.isBinary()) {
                    return -1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        }
    }
}

