/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DropActionHandler;
import com.intellij.openapi.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public class DnDDemo
implements DnDEvent.DropTargetHighlightingType {
    public static void main(String[] args) {
        JFrame frame = new JFrame("DnD Demo");
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        final JTree source = new JTree();
        panel.add((Component)source, "West");
        DnDManagerImpl dndManager = new DnDManagerImpl(null);
        dndManager.registerSource(new DnDSource(){

            public boolean canStartDragging(DnDAction action, Point dragOrigin) {
                return true;
            }

            public DnDDragStartBean startDragging(DnDAction action, Point point) {
                return new DnDDragStartBean((Object)source.getLastSelectedPathComponent().toString());
            }

            @Nullable
            public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
                return null;
            }

            public void dragDropEnd() {
            }

            public void dropActionChanged(int gestureModifiers) {
            }
        }, source);
        JTabbedPane tabs = new JTabbedPane();
        JPanel delegates = new JPanel(new FlowLayout());
        final JLabel delegate1Label = new JLabel("Delegate 1");
        delegates.add(delegate1Label);
        final JLabel delegate2Label = new JLabel("Delegate 2");
        delegates.add(delegate2Label);
        final DnDTarget delegee1 = new DnDTarget(){

            public boolean update(DnDEvent aEvent) {
                aEvent.setDropPossible(true, "Delegee 1");
                aEvent.setHighlighting((Component)delegate1Label, 5);
                return false;
            }

            public void drop(DnDEvent aEvent) {
                System.out.println("Delegee 1 accepted drop");
            }

            public void cleanUpOnLeave() {
            }

            public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            }
        };
        final DnDTarget delegee2 = new DnDTarget(){

            public boolean update(DnDEvent aEvent) {
                aEvent.setDropPossible("Delegee 2", new DropActionHandler(){

                    public void performDrop(DnDEvent aEvent) {
                        System.out.println("Delegee 2 accepted drop");
                    }
                });
                aEvent.setHighlighting((Component)delegate2Label, 9);
                return false;
            }

            public void drop(DnDEvent aEvent) {
            }

            public void cleanUpOnLeave() {
            }

            public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            }
        };
        dndManager.registerTarget(new DnDTarget(){

            public boolean update(DnDEvent aEvent) {
                if (aEvent.getCurrentOverComponent() == delegate1Label) {
                    return aEvent.delegateUpdateTo(delegee1);
                }
                if (aEvent.getCurrentOverComponent() == delegate2Label) {
                    return aEvent.delegateUpdateTo(delegee2);
                }
                aEvent.setDropPossible(false, "Nothing can be dropped here");
                return false;
            }

            public void drop(DnDEvent aEvent) {
                if (aEvent.getCurrentOverComponent() == delegate1Label) {
                    aEvent.delegateDropTo(delegee1);
                }
            }

            public void cleanUpOnLeave() {
            }

            public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            }
        }, delegates);
        tabs.add("Delegates", delegates);
        JPanel xy = new JPanel();
        dndManager.registerTarget(new DnDTarget(){

            public boolean update(DnDEvent aEvent) {
                aEvent.setDropPossible(true, "Drop to " + DnDDemo.asXyString(aEvent));
                return false;
            }

            public void drop(DnDEvent aEvent) {
                System.out.println("Droppped to " + DnDDemo.asXyString(aEvent));
            }

            public void cleanUpOnLeave() {
            }

            public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            }
        }, xy);
        tabs.add("XY drop", xy);
        panel.add((Component)tabs, "Center");
        frame.getContentPane().add((Component)panel, "Center");
        frame.setBounds(100, 100, 500, 500);
        frame.show();
    }

    public static String asXyString(DnDEvent aEvent) {
        return "[" + aEvent.getPoint().x + "," + aEvent.getPoint().y + "]";
    }
}

