/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesComparator;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewSelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FavoritesProjectViewPane
extends AbstractProjectViewPane {
    @NonNls
    public static final String ID = "Favorites";
    private FavoritesTreeViewPanel myViewPanel;
    private final ProjectView myProjectView;
    private final FavoritesManager myFavoritesManager;
    private final FavoritesManager.FavoritesListener myFavoritesListener;

    protected FavoritesProjectViewPane(Project project, ProjectView projectView, FavoritesManager favoritesManager) {
        super(project);
        this.myProjectView = projectView;
        this.myFavoritesManager = favoritesManager;
        this.myFavoritesListener = new FavoritesManager.FavoritesListener(){

            @Override
            public void rootsChanged(String listName) {
            }

            @Override
            public void listAdded(String listName) {
                this.refreshMySubIdsAndSelect(listName);
            }

            @Override
            public void listRemoved(String listName) {
                String selectedSubId = FavoritesProjectViewPane.this.getSubId();
                this.refreshMySubIdsAndSelect(selectedSubId);
            }

            private void refreshMySubIdsAndSelect(String listName) {
                FavoritesProjectViewPane.this.myFavoritesManager.removeFavoritesListener(FavoritesProjectViewPane.this.myFavoritesListener);
                FavoritesProjectViewPane.this.myProjectView.removeProjectPane(FavoritesProjectViewPane.this);
                FavoritesProjectViewPane.this.myProjectView.addProjectPane(FavoritesProjectViewPane.this);
                FavoritesProjectViewPane.this.myFavoritesManager.addFavoritesListener(FavoritesProjectViewPane.this.myFavoritesListener);
                if (ArrayUtil.find((Object[])FavoritesProjectViewPane.this.myFavoritesManager.getAvailableFavoritesLists(), (Object)listName) == -1) {
                    listName = null;
                }
                FavoritesProjectViewPane.this.myProjectView.changeView(FavoritesProjectViewPane.ID, listName);
            }
        };
        this.myFavoritesManager.addFavoritesListener(this.myFavoritesListener);
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"action.toolwindow.favorites", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/toolWindowFavorites.png");
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane.getId must not return null");
        }
        return ID;
    }

    @Override
    public void installComparator() {
        ProjectView projectView = ProjectView.getInstance(this.myProject);
        this.getTreeBuilder().setNodeDescriptorComparator((Comparator)new FavoritesComparator(projectView.isSortByType(ID), this.myProject));
    }

    @Override
    public JComponent createComponent() {
        this.myViewPanel = new FavoritesTreeViewPanel(this.myProject, null, this.getSubId());
        this.myTree = this.myViewPanel.getTree();
        this.setTreeBuilder(this.myViewPanel.getBuilder());
        this.myTreeStructure = this.myViewPanel.getFavoritesTreeStructure();
        this.installComparator();
        return this.myViewPanel;
    }

    @Override
    public void dispose() {
        this.myViewPanel = null;
        this.myFavoritesManager.removeFavoritesListener(this.myFavoritesListener);
        super.dispose();
    }

    @Override
    @NotNull
    public String[] getSubIds() {
        String[] stringArray = this.myFavoritesManager.getAvailableFavoritesLists();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane.getSubIds must not return null");
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane.getPresentableSubIdName must not be null");
        }
        String string = subId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesProjectViewPane.getPresentableSubIdName must not return null");
        }
        return string;
    }

    @Override
    public ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        return ((FavoritesViewTreeBuilder)this.getTreeBuilder()).updateFromRootCB();
    }

    @Override
    public void select(Object object, VirtualFile file, boolean requestFocus) {
        if (!(object instanceof PsiElement)) {
            return;
        }
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((PsiElement)object));
        String list = FavoritesViewSelectInTarget.findSuitableFavoritesList(virtualFile, this.myProject, this.getSubId());
        if (list == null) {
            return;
        }
        if (!list.equals(this.getSubId())) {
            ProjectView.getInstance(this.myProject).changeView(ID, list);
        }
        this.myViewPanel.selectElement(object, virtualFile, requestFocus);
    }

    @Override
    public int getWeight() {
        return 4;
    }

    @Override
    public SelectInTarget createSelectInTarget() {
        return new FavoritesViewSelectInTarget(this.myProject);
    }

    @Override
    public void addToolbarActions(DefaultActionGroup group) {
        group.add(ActionManager.getInstance().getAction("RenameFavoritesList"));
    }
}

