/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.macro.ColumnNumberMacro;
import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileDirRelativeToProjectRootMacro;
import com.intellij.ide.macro.FileDirRelativeToProjectRootMacro2;
import com.intellij.ide.macro.FileDirRelativeToSourcepathMacro;
import com.intellij.ide.macro.FileDirRelativeToSourcepathMacro2;
import com.intellij.ide.macro.FileExtMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.ide.macro.FilePathMacro;
import com.intellij.ide.macro.FilePathRelativeToProjectRootMacro;
import com.intellij.ide.macro.FilePathRelativeToProjectRootMacro2;
import com.intellij.ide.macro.FilePathRelativeToSourcepathMacro;
import com.intellij.ide.macro.FilePathRelativeToSourcepathMacro2;
import com.intellij.ide.macro.FileRelativeDirMacro;
import com.intellij.ide.macro.FileRelativeDirMacro2;
import com.intellij.ide.macro.FileRelativePathMacro;
import com.intellij.ide.macro.FileRelativePathMacro2;
import com.intellij.ide.macro.JdkPathMacro;
import com.intellij.ide.macro.LineNumberMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ModuleFileDirMacro;
import com.intellij.ide.macro.ModuleFilePathMacro;
import com.intellij.ide.macro.ModuleNameMacro;
import com.intellij.ide.macro.ModulePathMacro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.PromptMacro;
import com.intellij.ide.macro.SecondQueueExpandMacro;
import com.intellij.ide.macro.SourcepathEntryMacro;
import com.intellij.ide.macro.SourcepathMacro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConvertingIterator;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;

public final class MacroManager {
    private final HashMap<String, Macro> myMacrosMap = new HashMap();

    public static MacroManager getInstance() {
        return (MacroManager)ServiceManager.getService(MacroManager.class);
    }

    private MacroManager() {
        this.registerMacro(new SourcepathMacro());
        this.registerMacro(new FileDirMacro());
        this.registerMacro(new FileExtMacro());
        this.registerMacro(new FileNameMacro());
        this.registerMacro(new FileNameWithoutExtension());
        this.registerMacro(new FilePathMacro());
        this.registerMacro(new FileDirRelativeToProjectRootMacro());
        this.registerMacro(new FilePathRelativeToProjectRootMacro());
        this.registerMacro(new FileDirRelativeToSourcepathMacro());
        this.registerMacro(new FilePathRelativeToSourcepathMacro());
        this.registerMacro(new JdkPathMacro());
        this.registerMacro(new PromptMacro());
        this.registerMacro(new SourcepathEntryMacro());
        this.registerMacro(new ProjectFileDirMacro());
        this.registerMacro(new ProjectNameMacro());
        this.registerMacro(new ProjectPathMacro());
        this.registerMacro(new ModuleFilePathMacro());
        this.registerMacro(new ModuleFileDirMacro());
        this.registerMacro(new ModuleNameMacro());
        this.registerMacro(new ModulePathMacro());
        this.registerMacro(new FileRelativePathMacro());
        this.registerMacro(new FileRelativeDirMacro());
        this.registerMacro(new LineNumberMacro());
        this.registerMacro(new ColumnNumberMacro());
        if (File.separatorChar != '/') {
            this.registerMacro(new FileDirRelativeToProjectRootMacro2());
            this.registerMacro(new FilePathRelativeToProjectRootMacro2());
            this.registerMacro(new FileDirRelativeToSourcepathMacro2());
            this.registerMacro(new FilePathRelativeToSourcepathMacro2());
            this.registerMacro(new FileRelativeDirMacro2());
            this.registerMacro(new FileRelativePathMacro2());
        }
        for (Macro macro : (Macro[])Extensions.getExtensions(Macro.EP_NAME)) {
            this.registerMacro(macro);
        }
    }

    private void registerMacro(Macro macro) {
        assert (PathMacrosImpl.getToolMacroNames().contains(macro.getName())) : "Macro '" + macro.getName() + "' should be registered in PathMacros!";
        this.myMacrosMap.put((Object)macro.getName(), (Object)macro);
    }

    public Collection<Macro> getMacros() {
        return this.myMacrosMap.values();
    }

    public void cacheMacrosPreview(DataContext dataContext) {
        dataContext = MacroManager.getCorrectContext(dataContext);
        for (Macro macro : this.getMacros()) {
            macro.cachePreview(dataContext);
        }
    }

    private static DataContext getCorrectContext(DataContext dataContext) {
        if (PlatformDataKeys.FILE_EDITOR.getData(dataContext) != null) {
            return dataContext;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return dataContext;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        VirtualFile[] files = editorManager.getSelectedFiles();
        if (files.length == 0) {
            return dataContext;
        }
        FileEditor fileEditor = editorManager.getSelectedEditor(files[0]);
        return fileEditor == null ? dataContext : DataManager.getInstance().getDataContext((Component)fileEditor.getComponent());
    }

    public String expandMacrosInString(String str, boolean firstQueueExpand, DataContext dataContext) throws Macro.ExecutionCancelledException {
        return this.expandMacroSet(str, firstQueueExpand, dataContext, this.getMacros().iterator());
    }

    private String expandMacroSet(String str, boolean firstQueueExpand, DataContext dataContext, Iterator<Macro> macros) throws Macro.ExecutionCancelledException {
        if (str == null) {
            return null;
        }
        while (macros.hasNext()) {
            String name;
            Macro macro = macros.next();
            if (macro instanceof SecondQueueExpandMacro && firstQueueExpand || str.indexOf(name = "$" + macro.getName() + "$") < 0) continue;
            String expanded = macro.expand(dataContext);
            if (dataContext instanceof DataManagerImpl.MyDataContext) {
                ((DataManagerImpl.MyDataContext)dataContext).setEventCount(IdeEventQueue.getInstance().getEventCount());
            }
            if (expanded == null) {
                expanded = "";
            }
            str = StringUtil.replace((String)str, (String)name, (String)expanded);
        }
        return str;
    }

    public String expandSilentMarcos(String str, boolean firstQueueExpand, DataContext dataContext) throws Macro.ExecutionCancelledException {
        return this.expandMacroSet(str, firstQueueExpand, dataContext, (Iterator<Macro>)ConvertingIterator.create(this.getMacros().iterator(), (Convertor)new Convertor<Macro, Macro>(){

            public Macro convert(Macro macro) {
                if (macro instanceof PromptMacro) {
                    return new Macro.Silent(macro, "");
                }
                return macro;
            }
        }));
    }
}

