/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyPatchHunk;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplyFilePatchBase<T extends FilePatch>
implements ApplyFilePatch {
    protected final T myPatch;

    public ApplyFilePatchBase(T patch) {
        this.myPatch = patch;
    }

    public T getPatch() {
        return this.myPatch;
    }

    private FilePath getTarget(VirtualFile file) {
        if (this.myPatch.isNewFile()) {
            return new FilePathImpl(file, this.myPatch.getBeforeFileName(), false);
        }
        return new FilePathImpl(file);
    }

    @Override
    public ApplyPatchStatus apply(VirtualFile fileToPatch, ApplyPatchContext context, Project project) throws IOException, ApplyPatchException {
        context.addAffectedFile(this.getTarget(fileToPatch));
        return this.applyImpl(fileToPatch, project);
    }

    @Override
    public ApplyPatchStatus applyImpl(VirtualFile fileToPatch, Project project) throws IOException, ApplyPatchException {
        if (this.myPatch.isNewFile()) {
            this.applyCreate(fileToPatch);
        } else if (this.myPatch.isDeletedFile()) {
            FileEditorManagerImpl.getInstance((Project)project).closeFile(fileToPatch);
            fileToPatch.delete((Object)this);
        } else {
            return this.applyChange(fileToPatch);
        }
        return ApplyPatchStatus.SUCCESS;
    }

    protected abstract void applyCreate(VirtualFile var1) throws IOException, ApplyPatchException;

    @Nullable
    protected abstract ApplyPatchStatus applyChange(VirtualFile var1) throws IOException, ApplyPatchException;

    @Override
    @Nullable
    public VirtualFile findFileToPatch(@NotNull ApplyPatchContext context) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/apply/ApplyFilePatchBase.findFileToPatch must not be null");
        }
        return ApplyFilePatchBase.findPatchTarget(context, this.myPatch.getBeforeName(), this.myPatch.getAfterName(), this.myPatch.isNewFile());
    }

    @Nullable
    public static VirtualFile findPatchTarget(ApplyPatchContext context, String beforeName, String afterName, boolean isNewFile) throws IOException {
        VirtualFile file = null;
        if (beforeName != null) {
            file = ApplyFilePatchBase.findFileToPatchByName(context, beforeName, isNewFile);
        }
        if (file == null) {
            file = ApplyFilePatchBase.findFileToPatchByName(context, afterName, isNewFile);
        } else if (context.isAllowRename() && afterName != null && !beforeName.equals(afterName)) {
            boolean needMove;
            String[] afterNameComponents;
            String[] beforeNameComponents = beforeName.split("/");
            if (!beforeNameComponents[beforeNameComponents.length - 1].equals((afterNameComponents = afterName.split("/"))[afterNameComponents.length - 1])) {
                context.registerBeforeRename(file);
                file.rename(FilePatch.class, afterNameComponents[afterNameComponents.length - 1]);
                context.addAffectedFile(file);
            }
            boolean bl = needMove = beforeNameComponents.length != afterNameComponents.length;
            if (!needMove) {
                needMove = ApplyFilePatchBase.checkPackageRename(context, beforeNameComponents, afterNameComponents);
            }
            if (needMove) {
                VirtualFile moveTarget = ApplyFilePatchBase.findFileToPatchByComponents(context, afterNameComponents, afterNameComponents.length - 1);
                if (moveTarget == null) {
                    return null;
                }
                context.registerBeforeRename(file);
                file.move(FilePatch.class, moveTarget);
                context.addAffectedFile(file);
            }
        }
        return file;
    }

    private static boolean checkPackageRename(ApplyPatchContext context, String[] beforeNameComponents, String[] afterNameComponents) {
        int changedIndex = -1;
        for (int i = context.getSkipTopDirs(); i < afterNameComponents.length - 1; ++i) {
            if (beforeNameComponents[i].equals(afterNameComponents[i])) continue;
            if (changedIndex != -1) {
                return true;
            }
            changedIndex = i;
        }
        if (changedIndex == -1) {
            return false;
        }
        VirtualFile oldDir = ApplyFilePatchBase.findFileToPatchByComponents(context, beforeNameComponents, changedIndex + 1);
        VirtualFile newDir = ApplyFilePatchBase.findFileToPatchByComponents(context.getPrepareContext(), afterNameComponents, changedIndex + 1);
        if (oldDir != null && newDir == null) {
            context.addPendingRename(oldDir, afterNameComponents[changedIndex]);
            return false;
        }
        return true;
    }

    @Nullable
    private static VirtualFile findFileToPatchByName(@NotNull ApplyPatchContext context, String fileName, boolean isNewFile) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/apply/ApplyFilePatchBase.findFileToPatchByName must not be null");
        }
        String[] pathNameComponents = fileName.split("/");
        int lastComponentToFind = isNewFile ? pathNameComponents.length - 1 : pathNameComponents.length;
        return ApplyFilePatchBase.findFileToPatchByComponents(context, pathNameComponents, lastComponentToFind);
    }

    @Nullable
    private static VirtualFile findFileToPatchByComponents(ApplyPatchContext context, String[] pathNameComponents, int lastComponentToFind) {
        VirtualFile patchedDir = context.getBaseDir();
        for (int i = context.getSkipTopDirs(); i < lastComponentToFind; ++i) {
            VirtualFile nextChild = pathNameComponents[i].equals("..") ? patchedDir.getParent() : patchedDir.findChild(pathNameComponents[i]);
            if (nextChild == null) {
                if (context.isCreateDirectories()) {
                    try {
                        nextChild = patchedDir.createChildDirectory(null, pathNameComponents[i]);
                    }
                    catch (IOException e) {
                        return null;
                    }
                } else {
                    context.registerMissingDirectory(patchedDir, pathNameComponents, i);
                    return null;
                }
            }
            patchedDir = nextChild;
        }
        return patchedDir;
    }

    @Nullable
    public static ApplyPatchStatus applyModifications(TextFilePatch patch, CharSequence text, StringBuilder newText) throws ApplyPatchException {
        List hunks = patch.getHunks();
        if (hunks.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        ArrayList<String> lines = new ArrayList<String>();
        Collections.addAll(lines, LineTokenizer.tokenize((CharSequence)text, (boolean)false));
        ApplyPatchStatus result = null;
        for (PatchHunk hunk : hunks) {
            result = ApplyPatchStatus.and(result, new ApplyPatchHunk(hunk).apply(lines));
        }
        for (int i = 0; i < lines.size(); ++i) {
            newText.append((String)lines.get(i));
            if (i >= lines.size() - 1 && ((PatchHunk)hunks.get(hunks.size() - 1)).isNoNewLineAtEnd()) continue;
            newText.append("\n");
        }
        return result;
    }
}

