/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;

public class TextStartAction
extends TextComponentEditorAction {
    public TextStartAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void execute(Editor editor, DataContext dataContext) {
            editor.getCaretModel().moveToOffset(0);
            editor.getSelectionModel().removeSelection();
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
            scrollingModel.enableAnimation();
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            if (project != null) {
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            }
        }
    }
}

