/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorImpl
extends TextEditorImpl {
    private TextEditorBackgroundHighlighter myBackgroundHighlighter;

    public PsiAwareTextEditorImpl(@NotNull Project project, @NotNull VirtualFile file, TextEditorProvider provider) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl.<init> must not be null");
        }
        super(project, file, provider);
    }

    @Override
    protected TextEditorComponent createEditorComponent(Project project, VirtualFile file) {
        return new PsiAwareTextEditorComponent(project, file, this);
    }

    @Override
    public void initFolding() {
        CodeFoldingManager.getInstance(this.myProject).buildInitialFoldings(this.getEditor());
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new TextEditorBackgroundHighlighter(this.myProject, this.getEditor());
        }
        return this.myBackgroundHighlighter;
    }

    private static class PsiAwareTextEditorComponent
    extends TextEditorComponent {
        private final Project myProject;
        private final VirtualFile myFile;

        private PsiAwareTextEditorComponent(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextEditorImpl textEditor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent.<init> must not be null");
            }
            if (file == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent.<init> must not be null");
            }
            if (textEditor == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent.<init> must not be null");
            }
            super(project, file, textEditor);
            this.myProject = project;
            this.myFile = file;
        }

        @Override
        void dispose() {
            CodeFoldingManager.getInstance(this.myProject).releaseFoldings(this.getEditor());
            super.dispose();
        }

        @Override
        public Object getData(String dataId) {
            LookupImpl lookup;
            if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId) && (lookup = (LookupImpl)LookupManager.getInstance(this.myProject).getActiveLookup()) != null && lookup.isVisible()) {
                return lookup.getBounds();
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                return ModuleUtil.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
            }
            return super.getData(dataId);
        }
    }
}

