/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class ImportedFileType
extends AbstractFileType {
    private final List<FileNameMatcher> myPatterns = new ArrayList<FileNameMatcher>();

    public ImportedFileType(SyntaxTable syntaxTable, ExternalInfo copyFrom) {
        super(syntaxTable);
        if (copyFrom != null) {
            this.getExternalInfo().copy(copyFrom);
        }
    }

    public List<FileNameMatcher> getOriginalPatterns() {
        return this.myPatterns;
    }

    public void addPattern(FileNameMatcher pattern) {
        this.myPatterns.add(pattern);
    }

    public void readOriginalMatchers(Element element) {
        Element mappingsElement = element.getChild("extensionMap");
        if (mappingsElement != null) {
            List<Pair<FileNameMatcher, String>> list = AbstractFileType.readAssociations(mappingsElement);
            for (Pair<FileNameMatcher, String> pair : list) {
                this.addPattern((FileNameMatcher)pair.getFirst());
            }
        }
    }
}

