/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LazyRefreshingSelfQueue<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.LazyRefreshingSelfQueue");
    private final Getter<Long> myUpdateInterval;
    private final LinkedList<Pair<Long, T>> myQueue;
    private final Set<T> myInProgress;
    private final Computable<Boolean> myShouldUpdateOldChecker;
    private final Consumer<T> myUpdater;
    private final Object myLock;

    public LazyRefreshingSelfQueue(Getter<Long> updateInterval, Computable<Boolean> shouldUpdateOldChecker, Consumer<T> updater) {
        this.myUpdateInterval = updateInterval;
        this.myShouldUpdateOldChecker = shouldUpdateOldChecker;
        this.myUpdater = updater;
        this.myQueue = new LinkedList();
        this.myInProgress = new HashSet<T>();
        this.myLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/LazyRefreshingSelfQueue.addRequest must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.addFirst(new Pair(null, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequests(Collection<T> values) {
        Object object = this.myLock;
        synchronized (object) {
            for (T value : values) {
                this.myQueue.addFirst(new Pair(null, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRemove(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/LazyRefreshingSelfQueue.forceRemove must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myQueue.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                if (!t.equals(pair.getSecond())) continue;
                iterator.remove();
            }
            this.myInProgress.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStep(@NotNull ProgressIndicator pi) {
        if (pi == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/LazyRefreshingSelfQueue.updateStep must not be null");
        }
        LinkedList<Object> dirty = new LinkedList<Object>();
        long startTime = System.currentTimeMillis() - (Long)this.myUpdateInterval.get();
        boolean onlyAbsolute = true;
        Object object = this.myLock;
        synchronized (object) {
            for (Pair pair : this.myQueue) {
                if (pair.getFirst() == null) continue;
                onlyAbsolute = (Long)pair.getFirst() > startTime;
                break;
            }
        }
        pi.checkCanceled();
        Boolean shouldUpdateOld = onlyAbsolute ? false : (Boolean)this.myShouldUpdateOldChecker.compute();
        Iterator i$ = this.myLock;
        synchronized (i$) {
            while (!this.myQueue.isEmpty()) {
                pi.checkCanceled();
                Pair<Long, T> pair = this.myQueue.get(0);
                if (pair.getFirst() != null) break;
                dirty.add(this.myQueue.removeFirst().getSecond());
            }
            if (Boolean.TRUE.equals(shouldUpdateOld) && !this.myQueue.isEmpty()) {
                Pair<Long, T> pair;
                while (!this.myQueue.isEmpty() && (Long)(pair = this.myQueue.get(0)).getFirst() < startTime) {
                    this.myQueue.removeFirst();
                    dirty.add(pair.getSecond());
                }
            }
            this.myInProgress.addAll(dirty);
        }
        LOG.debug("found something to update: " + !dirty.isEmpty());
        for (Object e : dirty) {
            pi.checkCanceled();
            this.myUpdater.consume(e);
            Object object2 = this.myLock;
            synchronized (object2) {
                if (this.myInProgress.remove(e)) {
                    this.myQueue.addLast(new Pair((Object)System.currentTimeMillis(), e));
                }
            }
        }
    }
}

