/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;

public class ChangesBrowserLocallyDeletedNode
extends ChangesBrowserNode
implements TreeLinkMouseListener.HaveTooltip {
    private final Project myProject;

    public ChangesBrowserLocallyDeletedNode(LocallyDeletedChange userObject, Project project) {
        super(userObject);
        this.myProject = project;
        this.myCount = 1;
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    @Override
    protected FilePath getMyPath() {
        LocallyDeletedChange change = (LocallyDeletedChange)this.getUserObject();
        if (change != null) {
            return change.getPath();
        }
        return null;
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        LocallyDeletedChange change = (LocallyDeletedChange)this.getUserObject();
        FilePath filePath = change.getPath();
        String fileName = filePath.getName();
        VirtualFile vFile = filePath.getVirtualFile();
        Color changeColor = FileStatus.NOT_CHANGED.getColor();
        renderer.appendFileName(vFile, fileName, changeColor);
        if (renderer.isShowFlatten()) {
            File parentFile = filePath.getIOFile().getParentFile();
            if (parentFile != null) {
                renderer.append(" (" + parentFile.getPath() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (this.getCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        Icon addIcon = change.getAddIcon();
        if (addIcon != null) {
            renderer.setIcon(addIcon);
        } else if (filePath.isDirectory() || !this.isLeaf()) {
            renderer.setIcon(expanded ? Icons.DIRECTORY_OPEN_ICON : Icons.DIRECTORY_CLOSED_ICON);
        } else {
            renderer.setIcon(filePath.getFileType().getIcon());
        }
    }

    @Override
    public String getTooltip() {
        LocallyDeletedChange change = (LocallyDeletedChange)this.getUserObject();
        return change.getDescription();
    }
}

