/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import java.util.Iterator;
import java.util.List;

public class UpToDateLineNumberProviderImpl
implements UpToDateLineNumberProvider {
    private final Document myDocument;
    private final Project myProject;
    private final String myUpToDateContent;

    public UpToDateLineNumberProviderImpl(Document document, Project project, String upToDateContent) {
        this.myDocument = document;
        this.myProject = project;
        this.myUpToDateContent = upToDateContent;
    }

    public int getLineNumber(int currentNumber) {
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(this.myDocument);
        if (tracker == null) {
            tracker = LineStatusTrackerManager.getInstance(this.myProject).setUpToDateContent(this.myDocument, this.myUpToDateContent);
        }
        return UpToDateLineNumberProviderImpl.calcLineNumber(tracker, currentNumber);
    }

    private boolean endsWithSeparator(CharSequence string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char latest = string.charAt(string.length() - 1);
        return '\n' == latest || '\r' == latest;
    }

    private String fixLatestLineSeparator(Document document, String content) {
        CharSequence documentSequence = document.getCharsSequence();
        if (this.endsWithSeparator(documentSequence) && !this.endsWithSeparator(content)) {
            char beforeLatest;
            int numCharsToCopy = 1;
            int docLen = documentSequence.length();
            if (docLen > 1 && ('\r' == (beforeLatest = documentSequence.charAt(docLen - 2)) || '\n' == beforeLatest)) {
                numCharsToCopy = 2;
            }
            return content + documentSequence.subSequence(docLen - numCharsToCopy, docLen);
        }
        return content;
    }

    private static int calcLineNumber(LineStatusTracker tracker, int currentNumber) {
        if (tracker == null) {
            return -1;
        }
        List<Range> ranges = tracker.getRanges();
        int result = currentNumber;
        Iterator<Range> i$ = ranges.iterator();
        while (i$.hasNext()) {
            Range range1;
            Range range = range1 = i$.next();
            int startOffset = range.getOffset1();
            int endOffset = range.getOffset2();
            if (startOffset <= currentNumber && endOffset > currentNumber) {
                return -1;
            }
            if (endOffset > currentNumber) {
                return result;
            }
            int currentRangeLength = endOffset - startOffset;
            result += range.getUpToDateRangeLength() - currentRangeLength;
        }
        return result;
    }
}

