/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.peer.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VcsContextFactoryImpl
implements VcsContextFactory {
    public VcsContext createCachedContextOn(AnActionEvent event) {
        return VcsContextWrapper.createCachedInstanceOn(event);
    }

    public VcsContext createContextOn(AnActionEvent event) {
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace());
    }

    public FilePath createFilePathOn(final @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/peer/impl/VcsContextFactoryImpl.createFilePathOn must not be null");
        }
        return (FilePath)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FilePath>(){

            public FilePath compute() {
                return new FilePathImpl(virtualFile);
            }
        });
    }

    public FilePath createFilePathOn(final File file) {
        return (FilePath)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FilePath>(){

            public FilePath compute() {
                return FilePathImpl.create(file);
            }
        });
    }

    public FilePath createFilePathOn(final File file, final NotNullFunction<File, Boolean> detector) {
        return (FilePath)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FilePath>(){

            public FilePath compute() {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (virtualFile != null) {
                    return FilePathImpl.create(file);
                }
                return FilePathImpl.create(file, (Boolean)detector.fun((Object)file));
            }
        });
    }

    public FilePath createFilePathOn(final File file, final boolean isDirectory) {
        return (FilePath)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FilePath>(){

            public FilePath compute() {
                return FilePathImpl.create(file, isDirectory);
            }
        });
    }

    @NotNull
    public FilePath createFilePathOnNonLocal(String path, boolean isDirectory) {
        FilePath filePath = FilePathImpl.createNonLocal(path, isDirectory);
        if (filePath == null) {
            throw new IllegalStateException("@NotNull method com/intellij/peer/impl/VcsContextFactoryImpl.createFilePathOnNonLocal must not return null");
        }
        return filePath;
    }

    public FilePath createFilePathOnDeleted(final File file, final boolean isDirectory) {
        return (FilePath)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FilePath>(){

            public FilePath compute() {
                return FilePathImpl.createForDeletedFile(file, isDirectory);
            }
        });
    }

    public FilePath createFilePathOn(final VirtualFile parent, final String name) {
        return (FilePath)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FilePath>(){

            public FilePath compute() {
                return new FilePathImpl(parent, name, false);
            }
        });
    }

    public LocalChangeList createLocalChangeList(Project project, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/peer/impl/VcsContextFactoryImpl.createLocalChangeList must not be null");
        }
        return LocalChangeListImpl.createEmptyChangeListImpl(project, name);
    }
}

