/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.java.stubs.index.JavaFieldNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaShortClassNameIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class PsiShortNamesCacheImpl
extends PsiShortNamesCache {
    private final PsiManagerEx myManager;

    public PsiShortNamesCacheImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getFilesByName must not be null");
        }
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName(this.myManager.getProject(), name, GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getFilesByName must not return null");
        }
        return psiFileArray;
    }

    @NotNull
    public String[] getAllFileNames() {
        String[] stringArray = FilenameIndex.getAllFilenames(this.myManager.getProject());
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getAllFileNames must not return null");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getClassesByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getClassesByName must not be null");
        }
        Collection<PsiClass> classes = JavaShortClassNameIndex.getInstance().get(name, this.myManager.getProject(), scope);
        if (classes.isEmpty()) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
            if (PsiClass.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getClassesByName must not return null");
            return psiClassArray;
        }
        ArrayList<PsiClass> list = new ArrayList<PsiClass>(classes.size());
        Iterator<PsiClass> i$ = classes.iterator();
        block0: while (true) {
            VirtualFile vFile;
            PsiClass aClass;
            if (i$.hasNext()) {
                aClass = i$.next();
                vFile = aClass.getContainingFile().getVirtualFile();
                if (!scope.contains(vFile)) continue;
            } else {
                psiClassArray = list.toArray(new PsiClass[list.size()]);
                if (psiClassArray != null) return psiClassArray;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getClassesByName must not return null");
            }
            for (int j = 0; j < list.size(); ++j) {
                PsiClass aClass1 = (PsiClass)list.get(j);
                String qName = aClass.getQualifiedName();
                String qName1 = aClass1.getQualifiedName();
                if (qName == null || qName1 == null || !qName.equals(qName1)) continue;
                VirtualFile vFile1 = aClass1.getContainingFile().getVirtualFile();
                int res = scope.compare(vFile1, vFile);
                if (res > 0) continue block0;
                if (res >= 0) continue;
                list.remove(j);
                --j;
            }
            list.add(aClass);
        }
    }

    @NotNull
    public String[] getAllClassNames() {
        Collection names = JavaShortClassNameIndex.getInstance().getAllKeys(this.myManager.getProject());
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getAllClassNames must not return null");
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getAllClassNames must not be null");
        }
        set.addAll(JavaShortClassNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        PsiMethod[] psiMethodArray;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getMethodsByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getMethodsByName must not be null");
        }
        Collection methods = StubIndex.getInstance().get(JavaMethodNameIndex.KEY, (Object)name, this.myManager.getProject(), scope);
        if (methods.isEmpty()) {
            psiMethodArray = PsiMethod.EMPTY_ARRAY;
            if (PsiMethod.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getMethodsByName must not return null");
            return psiMethodArray;
        }
        List<PsiMethod> list = this.filterMembers(methods, scope);
        psiMethodArray = list.toArray(new PsiMethod[list.size()]);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getMethodsByName must not return null");
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getMethodsByNameIfNotMoreThan must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getMethodsByNameIfNotMoreThan must not be null");
        }
        PsiMethod[] psiMethodArray = this.getMethodsByName(name, scope);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getMethodsByNameIfNotMoreThan must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Collection names = JavaMethodNameIndex.getInstance().getAllKeys(this.myManager.getProject());
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getAllMethodNames must not return null");
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getAllMethodNames must not be null");
        }
        set.addAll(JavaMethodNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        PsiField[] psiFieldArray;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getFieldsByName must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getFieldsByName must not be null");
        }
        Collection<PsiField> fields = JavaFieldNameIndex.getInstance().get(name, this.myManager.getProject(), scope);
        if (fields.isEmpty()) {
            psiFieldArray = PsiField.EMPTY_ARRAY;
            if (PsiField.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getFieldsByName must not return null");
            return psiFieldArray;
        }
        List<PsiField> list = this.filterMembers(fields, scope);
        psiFieldArray = list.toArray(new PsiField[list.size()]);
        if (psiFieldArray != null) return psiFieldArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getFieldsByName must not return null");
    }

    @NotNull
    public String[] getAllFieldNames() {
        Collection names = JavaFieldNameIndex.getInstance().getAllKeys(this.myManager.getProject());
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiShortNamesCacheImpl.getAllFieldNames must not return null");
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiShortNamesCacheImpl.getAllFieldNames must not be null");
        }
        set.addAll(JavaFieldNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
    }

    private <T extends PsiMember> List<T> filterMembers(Collection<T> members, GlobalSearchScope scope) {
        ArrayList<PsiMember> result = new ArrayList<PsiMember>();
        THashSet set = new THashSet(members.size(), (TObjectHashingStrategy)new TObjectHashingStrategy<PsiMember>(){

            public int computeHashCode(PsiMember member) {
                int code = 0;
                PsiClass clazz = member.getContainingClass();
                if (clazz != null) {
                    String name = clazz.getName();
                    code = name != null ? (code += name.hashCode()) : (code += clazz.hashCode());
                }
                if (member instanceof PsiMethod) {
                    code += 37 * ((PsiMethod)member).getParameterList().getParametersCount();
                }
                return code;
            }

            public boolean equals(PsiMember object, PsiMember object1) {
                return PsiShortNamesCacheImpl.this.myManager.areElementsEquivalent((PsiElement)object, (PsiElement)object1);
            }
        });
        for (PsiMember member : members) {
            ProgressManager.checkCanceled();
            if (!scope.contains(member.getContainingFile().getVirtualFile()) || !set.add(member)) continue;
            result.add(member);
        }
        return result;
    }
}

