/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(final OverridingMethodsSearch.SearchParameters p, final Processor<PsiMethod> consumer) {
        final PsiMethod method = p.getMethod();
        SearchScope scope = p.getScope();
        final PsiClass parentClass = method.getContainingClass();
        Processor<PsiClass> inheritorsProcessor = new Processor<PsiClass>(){

            public boolean process(PsiClass inheritor) {
                PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                MethodSignature signature = method.getSignature(substitutor);
                PsiMethod found = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)signature, (boolean)false);
                if (found == null || !JavaOverridingMethodsSearcher.isAcceptable(found, method)) {
                    PsiClass superClass;
                    if (parentClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(parentClass, true) && (found = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)signature, (boolean)true)) != null && JavaOverridingMethodsSearcher.isAcceptable(found, method)) {
                        return consumer.process((Object)found) && p.isCheckDeep();
                    }
                    return true;
                }
                return consumer.process((Object)found) && p.isCheckDeep();
            }
        };
        return ClassInheritorsSearch.search((PsiClass)parentClass, (SearchScope)scope, (boolean)true).forEach((Processor)inheritorsProcessor);
    }

    private static boolean isAcceptable(PsiMethod found, PsiMethod method) {
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)found.getProject()).arePackagesTheSame((PsiElement)method.getContainingClass(), (PsiElement)found.getContainingClass()));
    }
}

