/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.PsiTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(PsiVariable variable) {
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        return JavaSharedImplUtil.getType(typeElement, (PsiElement)nameIdentifier, (PsiElement)variable);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @NotNull PsiElement context) {
        if (typeElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getType must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getType must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getType must not be null");
        }
        int cStyleArrayCount = 0;
        ASTNode name = SourceTreeToPsiMap.psiElementToTree(anchor);
        for (ASTNode child = name.getTreeNext(); child != null; child = child.getTreeNext()) {
            IElementType i = child.getElementType();
            if (i == JavaTokenType.LBRACKET) {
                ++cStyleArrayCount;
                continue;
            }
            if (i != JavaTokenType.RBRACKET && i != TokenType.WHITE_SPACE && i != JavaTokenType.C_STYLE_COMMENT && i != JavaDocElementType.DOC_COMMENT && i != JavaTokenType.DOC_COMMENT && i != JavaTokenType.END_OF_LINE_COMMENT) break;
        }
        PsiType type = typeElement instanceof PsiTypeElementImpl ? ((PsiTypeElementImpl)typeElement).getDetachedType(context) : typeElement.getType();
        for (int i = 0; i < cStyleArrayCount; ++i) {
            type = type.createArrayType();
        }
        return type;
    }

    public static PsiType getTypeNoResolve(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @NotNull PsiElement context) {
        if (typeElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getTypeNoResolve must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getTypeNoResolve must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getTypeNoResolve must not be null");
        }
        int cStyleArrayCount = 0;
        ASTNode name = SourceTreeToPsiMap.psiElementToTree(anchor);
        for (ASTNode child = name.getTreeNext(); child != null; child = child.getTreeNext()) {
            IElementType i = child.getElementType();
            if (i == JavaTokenType.LBRACKET) {
                ++cStyleArrayCount;
                continue;
            }
            if (i != JavaTokenType.RBRACKET && i != TokenType.WHITE_SPACE && i != JavaTokenType.C_STYLE_COMMENT && i != JavaDocElementType.DOC_COMMENT && i != JavaTokenType.DOC_COMMENT && i != JavaTokenType.END_OF_LINE_COMMENT) break;
        }
        PsiType type = typeElement.getTypeNoResolve(context);
        for (int i = 0; i < cStyleArrayCount; ++i) {
            type = type.createArrayType();
        }
        return type;
    }

    public static void normalizeBrackets(PsiVariable variable) {
        CompositeElement variableElement = (CompositeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)variable);
        ASTNode type = variableElement.findChildByRole(10);
        LOG.assertTrue(type.getTreeParent() == variableElement);
        ASTNode name = variableElement.findChildByRole(9);
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name;
        while (element != null && (element = TreeUtil.skipElements(element.getTreeNext(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = TreeUtil.skipElements(element.getTreeNext(), StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                variableElement.removeChild(element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type.clone();
            CharTable treeCharTable = SharedImplUtil.findCharTableByTree(type);
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type));
            variableElement.replaceChild(type, newType);
        }
    }

    public static void setInitializer(PsiVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        PsiExpression oldInitializer = variable.getInitializer();
        if (oldInitializer != null) {
            oldInitializer.delete();
        }
        if (initializer == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            variableElement.addInternal((TreeElement)eq, eq, variable.getNameIdentifier().getNode(), Boolean.FALSE);
            eq = variableElement.findChildByRole(20);
        }
        variable.addAfter((PsiElement)initializer, eq.getPsi());
    }
}

