/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.OldXmlLexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.parsing.xml.XmlParsingContext;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.psi.tree.xml.IXmlElementType;
import com.intellij.psi.xml.XmlTextElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;

public interface XmlElementType
extends XmlTokenType {
    public static final IElementType XML_DOCUMENT = new IXmlElementType("XML_DOCUMENT");
    public static final IElementType XML_PROLOG = new IXmlElementType("XML_PROLOG");
    public static final IElementType XML_DECL = new IXmlElementType("XML_DECL");
    public static final IElementType XML_DOCTYPE = new IXmlElementType("XML_DOCTYPE");
    public static final IElementType XML_ATTRIBUTE = new IXmlElementType("XML_ATTRIBUTE");
    public static final IElementType XML_COMMENT = new IXmlElementType("XML_COMMENT");
    public static final IElementType XML_TAG = new IXmlElementType("XML_TAG");
    public static final IElementType XML_ELEMENT_DECL = new IXmlElementType("XML_ELEMENT_DECL");
    public static final IElementType XML_CONDITIONAL_SECTION = new IXmlElementType("XML_CONDITIONAL_SECTION");
    public static final IElementType XML_ATTLIST_DECL = new IXmlElementType("XML_ATTLIST_DECL");
    public static final IElementType XML_NOTATION_DECL = new IXmlElementType("XML_NOTATION_DECL");
    public static final IElementType XML_ENTITY_DECL = new IXmlElementType("XML_ENTITY_DECL");
    public static final IElementType XML_ELEMENT_CONTENT_SPEC = new IXmlElementType("XML_ELEMENT_CONTENT_SPEC");
    public static final IElementType XML_ATTRIBUTE_DECL = new IXmlElementType("XML_ATTRIBUTE_DECL");
    public static final IElementType XML_ATTRIBUTE_VALUE = new IXmlElementType("XML_ATTRIBUTE_VALUE");
    public static final IElementType XML_ENTITY_REF = new IXmlElementType("XML_ENTITY_REF");
    public static final IElementType XML_ENUMERATED_TYPE = new IXmlElementType("XML_ENUMERATED_TYPE");
    public static final IElementType XML_PROCESSING_INSTRUCTION = new IXmlElementType("XML_PROCESSING_INSTRUCTION");
    public static final IElementType XML_CDATA = new IXmlElementType("XML_CDATA");
    public static final IElementType XML_DTD_DECL = new IXmlElementType("XML_DTD_DECL");
    public static final IElementType XML_WHITE_SPACE_HOLDER = new IXmlElementType("XML_WHITE_SPACE_HOLDER");
    public static final IElementType HTML_DOCUMENT = new IXmlElementType("HTML_DOCUMENT");
    public static final IElementType HTML_TAG = new IXmlElementType("HTML_TAG");
    public static final IFileElementType HTML_FILE = new IFileElementType((Language)HTMLLanguage.INSTANCE);
    public static final IElementType XML_TEXT = new XmlTextElementType();
    public static final IFileElementType XML_FILE = new IFileElementType((Language)XMLLanguage.INSTANCE);
    public static final IElementType XHTML_FILE = new IFileElementType((Language)XHTMLLanguage.INSTANCE);
    public static final IElementType DTD_FILE = new IReparseableElementType("DTD_FILE", DTDLanguage.INSTANCE){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            CharTable table = SharedImplUtil.findCharTableByTree(chameleon);
            XmlParsingContext parsingContext = new XmlParsingContext(table);
            return parsingContext.getXmlParsing().parse((Lexer)new OldXmlLexer(), chars, 0, chars.length(), SharedImplUtil.getManagerByTree(chameleon));
        }

        public boolean isParsable(CharSequence buffer, Project project) {
            return true;
        }
    };
    public static final IElementType XML_MARKUP;
    public static final IElementType XML_MARKUP_DECL;

    static {
        XML_MARKUP_DECL = XML_MARKUP = new CustomParsingType("XML_MARKUP_DECL", (Language)XMLLanguage.INSTANCE){

            public ASTNode parse(CharSequence text, CharTable table) {
                XmlParsingContext parsingContext = new XmlParsingContext(table);
                return parsingContext.getXmlParsing().parseMarkupDecl(text);
            }
        };
    }
}

