/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

class CopyClassDialog
extends DialogWrapper {
    @NonNls
    private static final String RECENTS_KEY = "CopyClassDialog.RECENTS_KEY";
    private final JLabel myInformationLabel = new JLabel();
    private final JLabel myNameLabel = new JLabel();
    private EditorTextField myNameField;
    private final JLabel myPackageLabel = new JLabel();
    private ReferenceEditorComboWithBrowseButton myTfPackage;
    private final Project myProject;
    private PsiDirectory myTargetDirectory;
    private final boolean myDoClone;
    private final PsiDirectory myDefaultTargetDirectory;
    private JCheckBox myCbMoveToAnotherSourceFolder = new JCheckBox(RefactoringBundle.message((String)"move.classes.move.to.another.source.folder"));

    public CopyClassDialog(PsiClass aClass, PsiDirectory defaultTargetDirectory, Project project, boolean doClone) {
        super(project, true);
        this.myProject = project;
        this.myDefaultTargetDirectory = defaultTargetDirectory;
        this.init();
        this.myDoClone = doClone;
        String text = this.myDoClone ? RefactoringBundle.message((String)"copy.class.clone.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)aClass), UsageViewUtil.getLongName((PsiElement)aClass)}) : RefactoringBundle.message((String)"copy.class.copy.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)aClass), UsageViewUtil.getLongName((PsiElement)aClass)});
        this.myInformationLabel.setText(text);
        this.myNameField.setText(UsageViewUtil.getShortName((PsiElement)aClass));
        this.myNameLabel.setText(RefactoringBundle.message((String)"name.prompt"));
        if (this.myDoClone) {
            this.myTfPackage.setVisible(false);
            this.myPackageLabel.setVisible(false);
            this.myCbMoveToAnotherSourceFolder.setVisible(false);
        }
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        PsiPackage aPackage;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        panel.setBorder(IdeBorderFactory.createBorder());
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myInformationLabel, gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridy = 1;
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 0.0;
        panel.add((Component)this.myNameLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        this.myNameField = new EditorTextField("");
        panel.add((Component)this.myNameField, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        gbConstraints.weightx = 0.0;
        panel.add((Component)this.myPackageLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        String qualifiedName = "";
        if (this.myDefaultTargetDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(this.myDefaultTargetDirectory)) != null) {
            qualifiedName = aPackage.getQualifiedName();
        }
        this.myTfPackage = new PackageNameReferenceEditorCombo(qualifiedName, this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        if (qualifiedName.length() > 0) {
            this.myTfPackage.setTextFieldPreferredWidth(qualifiedName.length() + 5);
        }
        this.myPackageLabel.setText(RefactoringBundle.message((String)"destination.package"));
        panel.add((Component)((Object)this.myTfPackage), gbConstraints);
        this.myCbMoveToAnotherSourceFolder.setEnabled(ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots().length > 1);
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 2;
        gbConstraints.anchor = 13;
        gbConstraints.fill = 0;
        panel.add((Component)this.myCbMoveToAnotherSourceFolder, gbConstraints);
        return panel;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getClassName() {
        return this.myNameField.getText();
    }

    protected void doOKAction() {
        String packageName = this.myTfPackage.getText();
        final String className = this.getClassName();
        final String[] errorString = new String[1];
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiNameHelper nameHelper = JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper();
        if (packageName.length() > 0 && !nameHelper.isQualifiedName(packageName)) {
            errorString[0] = RefactoringBundle.message((String)"invalid.target.package.name.specified");
        } else if ("".equals(className)) {
            errorString[0] = RefactoringBundle.message((String)"no.class.name.specified");
        } else {
            if (!nameHelper.isIdentifier(className)) {
                errorString[0] = RefactoringMessageUtil.getIncorrectIdentifierMessage(className);
            } else if (!this.myDoClone) {
                try {
                    if (this.myCbMoveToAnotherSourceFolder.isSelected() && this.myCbMoveToAnotherSourceFolder.isEnabled()) {
                        final PackageWrapper targetPackage = new PackageWrapper(manager, packageName);
                        final VirtualFile sourceRoot = MoveClassesOrPackagesUtil.chooseSourceRoot(targetPackage, ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots(), this.myDefaultTargetDirectory);
                        if (sourceRoot == null) {
                            return;
                        }
                        new WriteCommandAction(this.myProject, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), new PsiFile[0]){

                            protected void run(Result objectResult) throws Throwable {
                                CopyClassDialog.this.myTargetDirectory = RefactoringUtil.createPackageDirectoryInSourceRoot(targetPackage, sourceRoot);
                            }
                        }.execute();
                    } else {
                        Module module = ModuleUtil.findModuleForFile((VirtualFile)this.myDefaultTargetDirectory.getVirtualFile(), (Project)this.myProject);
                        if (module != null) {
                            this.myTargetDirectory = PackageUtil.findOrCreateDirectoryForPackage(module, packageName, this.myDefaultTargetDirectory, true);
                        } else {
                            errorString[0] = "No module found for directory '" + this.myDefaultTargetDirectory.getVirtualFile().getPresentableUrl() + "'";
                        }
                    }
                    if (this.myTargetDirectory == null) {
                        if (errorString[0] == null) {
                            errorString[0] = "";
                        }
                    } else {
                        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        errorString[0] = RefactoringMessageUtil.checkCanCreateClass(CopyClassDialog.this.myTargetDirectory, className);
                                    }
                                });
                            }
                        }, RefactoringBundle.message((String)"create.directory"), null);
                    }
                }
                catch (IncorrectOperationException e) {
                    errorString[0] = e.getMessage();
                }
            }
            RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        }
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)errorString[0], (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
            this.myNameField.requestFocusInWindow();
            return;
        }
        super.doOKAction();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.copyClass");
    }
}

