/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.util.IncorrectOperationException;

public class FileReferenceContextUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.FileReferenceContextUtil");
    private static final Key<PsiFileSystemItem> REF_FILE_SYSTEM_ITEM_KEY = Key.create((String)"REF_FILE_SYSTEM_ITEM_KEY");

    private FileReferenceContextUtil() {
    }

    public static void encodeFileReferences(PsiElement element) {
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(true){

            public void visitElement(PsiElement element) {
                FileReference ref;
                PsiReference[] refs = element.getReferences();
                if (refs.length > 0 && refs[0] instanceof FileReferenceOwner && (ref = ((FileReferenceOwner)refs[0]).getLastFileReference()) != null) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ref.multiResolve(false)) {
                        if (!(result.getElement() instanceof PsiFileSystemItem)) continue;
                        element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, (Object)((PsiFileSystemItem)result.getElement()));
                        break;
                    }
                }
                super.visitElement(element);
            }
        });
    }

    public static void decodeFileReferences(PsiElement element) {
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(true){

            public void visitElement(PsiElement element) {
                FileReference ref;
                PsiReference[] refs;
                PsiFileSystemItem item = (PsiFileSystemItem)element.getCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY);
                element.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, null);
                if (item != null && item.isValid() && (refs = element.getReferences()).length > 0 && refs[0] instanceof FileReferenceOwner && (ref = ((FileReferenceOwner)refs[0]).getLastFileReference()) != null) {
                    try {
                        element = ref.bindToElement((PsiElement)item);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                if (element != null) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
    }
}

