/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import java.util.HashSet;

public class MoveFilesOrDirectoriesHandler
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler");

    @Override
    public boolean canMove(PsiElement[] elements, PsiElement targetContainer) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            if (element instanceof PsiFile) {
                PsiFile file = (PsiFile)element;
                String name = file.getName();
                if (names.contains(name)) {
                    return false;
                }
                names.add(name);
                continue;
            }
            if (element instanceof PsiDirectory) continue;
            return false;
        }
        PsiElement[] filteredElements = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        if (filteredElements.length != elements.length) {
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    @Override
    public boolean isValidTarget(PsiElement psiElement) {
        return psiElement instanceof PsiDirectory || psiElement instanceof PsiDirectoryContainer;
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        if (!LOG.assertTrue(targetContainer == null || targetContainer instanceof PsiDirectory || targetContainer instanceof PsiDirectoryContainer)) {
            return;
        }
        MoveFilesOrDirectoriesUtil.doMove(project, this.adjustForMove(project, elements, targetContainer), new PsiElement[]{targetContainer}, callback);
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (element instanceof PsiFile && ((PsiFile)element).getVirtualFile() != null || element instanceof PsiDirectory) {
            this.doMove(project, new PsiElement[]{element}, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
            return true;
        }
        if (element instanceof PsiPlainText) {
            PsiFile file = element.getContainingFile();
            if (file != null) {
                this.doMove(project, new PsiElement[]{file}, null, null);
            }
            return true;
        }
        return false;
    }
}

