/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import junit.framework.Assert;
import org.jetbrains.annotations.NonNls;

@NonNls
public class PsiTestUtil {
    public static VirtualFile createTestProjectStructure(Project project, Module module, String rootPath, Collection<File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project, module, rootPath, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project, Module module, Collection<File> filesToDelete) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project, module, null, filesToDelete, true);
    }

    public static VirtualFile createTestProjectStructure(Project project, Module module, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws Exception {
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure(module, rootPath, filesToDelete, addProjectRoots);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        return vDir;
    }

    public static VirtualFile createTestProjectStructure(Module module, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws Exception {
        return PsiTestUtil.createTestProjectStructure("unitTest", module, rootPath, filesToDelete, addProjectRoots);
    }

    public static VirtualFile createTestProjectStructure(String tempName, Module module, String rootPath, Collection<File> filesToDelete, boolean addProjectRoots) throws Exception {
        File dir = FileUtil.createTempDirectory((String)tempName, null);
        filesToDelete.add(dir);
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
        if (rootPath != null) {
            VirtualFile vDir1 = LocalFileSystem.getInstance().findFileByPath(rootPath.replace(File.separatorChar, '/'));
            if (vDir1 == null) {
                throw new Exception(rootPath + " not found");
            }
            VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)vDir, null);
        }
        if (addProjectRoots) {
            PsiTestUtil.addSourceContentToRoots(module, vDir);
        }
        return vDir;
    }

    public static void removeAllRoots(Module module, Sdk jdk) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        rootModel.clear();
        rootModel.setSdk(jdk);
        rootModel.commit();
    }

    public static void addSourceContentToRoots(Module module, VirtualFile vDir) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        ContentEntry contentEntry = rootModel.addContentEntry(vDir);
        contentEntry.addSourceFolder(vDir, false);
        rootModel.commit();
    }

    public static void addSourceRoot(Module module, VirtualFile vDir) {
        PsiTestUtil.addSourceRoot(module, vDir, false);
    }

    public static void addSourceRoot(Module module, final VirtualFile vDir, boolean isTestSource) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        Object[] contentEntries = rootModel.getContentEntries();
        ContentEntry entry = (ContentEntry)ContainerUtil.find((Object[])contentEntries, (Condition)new Condition<ContentEntry>(){

            public boolean value(ContentEntry object) {
                return VfsUtil.isAncestor((VirtualFile)object.getFile(), (VirtualFile)vDir, (boolean)false);
            }
        });
        if (entry == null) {
            entry = rootModel.addContentEntry(vDir);
        }
        entry.addSourceFolder(vDir, isTestSource);
        rootModel.commit();
    }

    public static ContentEntry addContentRoot(Module module, VirtualFile vDir) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        rootModel.addContentEntry(vDir);
        rootModel.commit();
        for (ContentEntry entry : rootManager.getContentEntries()) {
            if (entry.getFile() != vDir) continue;
            Assert.assertFalse((boolean)((ContentEntryImpl)entry).isDisposed());
            return entry;
        }
        return null;
    }

    public static void removeContentEntry(Module m, ContentEntry e) {
        ModuleRootManager rootModel = ModuleRootManager.getInstance((Module)m);
        ModifiableRootModel model = rootModel.getModifiableModel();
        model.removeContentEntry(e);
        model.commit();
    }

    public static void checkFileStructure(PsiFile file) throws IncorrectOperationException {
        String originalTree = DebugUtil.psiTreeToString((PsiElement)file, false);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText(file.getName(), file.getText());
        String reparsedTree = DebugUtil.psiTreeToString((PsiElement)dummyFile, false);
        Assert.assertEquals((String)reparsedTree, (String)originalTree);
    }

    public static void addLibrary(final Module module, final String libName, final String libPath, final String ... jarArr) {
        assert (ModuleRootManager.getInstance((Module)module).getContentRoots().length > 0) : "content roots must not be empty";
        new WriteCommandAction(module.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                LibraryTable libraryTable = ProjectLibraryTable.getInstance(module.getProject());
                Library library = libraryTable.createLibrary(libName);
                Library.ModifiableModel libraryModel = library.getModifiableModel();
                for (String jar : jarArr) {
                    String path = libPath + jar;
                    VirtualFile root = JarFileSystem.getInstance().refreshAndFindFileByPath(path + "!/");
                    assert (root != null) : "Library root folder not found: " + path + "!/";
                    libraryModel.addRoot(root, OrderRootType.CLASSES);
                }
                libraryModel.commit();
                model.addLibraryEntry(library);
                OrderEntry[] orderEntries = model.getOrderEntries();
                OrderEntry last = orderEntries[orderEntries.length - 1];
                for (int i = orderEntries.length - 2; i > -1; --i) {
                    orderEntries[i + 1] = orderEntries[i];
                }
                orderEntries[0] = last;
                model.rearrangeOrderEntries(orderEntries);
                model.commit();
            }
        }.execute();
    }
}

