/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import java.awt.Component;

public abstract class PopupUpdateProcessor
extends JBPopupAdapter {
    private Project myProject;

    protected PopupUpdateProcessor(Project project) {
        this.myProject = project;
    }

    public abstract void updatePopup(Object var1);

    public void beforeShown(final LightweightWindowEvent windowEvent) {
        final Lookup activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null) {
            activeLookup.addLookupListener(new LookupAdapter(){

                @Override
                public void currentItemChanged(LookupEvent event) {
                    LookupElement item;
                    if (windowEvent.asPopup().isVisible() && (item = event.getItem()) != null) {
                        windowEvent.asPopup().cancel();
                        PopupUpdateProcessor.this.updatePopup(item.getObject());
                    }
                    activeLookup.removeLookupListener(this);
                }
            });
        } else {
            boolean fromQuickSearch;
            Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
            boolean bl = fromQuickSearch = focusedComponent != null && focusedComponent.getParent() instanceof ChooseByNameBase.JPanelProvider;
            if (fromQuickSearch) {
                ChooseByNameBase.JPanelProvider panelProvider = (ChooseByNameBase.JPanelProvider)focusedComponent.getParent();
                panelProvider.registerHint(windowEvent.asPopup());
            }
        }
    }
}

