/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.AbstractActionFromEditGroup;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditorInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditorsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.ui.EditorsPanel;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.actions.VcsContext;
import java.util.List;
import javax.swing.Icon;

public class ViewEditorsAction
extends AbstractActionFromEditGroup {
    private EditorsOperation myEditorsOperation;

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.getViewEditorsOperationName();
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        this.myEditorsOperation = new EditorsOperation(context.getSelectedFiles());
        return new CommandCvsHandler(CvsBundle.getViewEditorsOperationName(), this.myEditorsOperation);
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        if (successfully) {
            List<EditorInfo> editors = this.myEditorsOperation.getEditors();
            String filePath = CvsVfsUtil.getFileFor(context.getSelectedFile()).getAbsolutePath();
            if (editors.isEmpty()) {
                Messages.showMessageDialog((String)CvsBundle.message((String)"message.error.no.editors.for.file", (Object[])new Object[]{filePath}), (String)CvsBundle.message((String)"message.error.no.editors.for.file.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            } else {
                tabbedWindow.addTab(CvsBundle.message((String)"message.editors.for.file", (Object[])new Object[]{filePath}), new EditorsPanel(context.getProject(), editors), true, true, true, true, null, "cvs.editors");
                tabbedWindow.ensureVisible(context.getProject());
            }
        }
    }
}

