/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class CvsRepositoryLocation
implements RepositoryLocation {
    private final VirtualFile myRootFile;
    private final CvsEnvironment myEnvironment;
    private final String myModuleName;

    public CvsRepositoryLocation(@Nullable VirtualFile rootFile, CvsEnvironment environment, String moduleName) {
        this.myRootFile = rootFile;
        this.myEnvironment = environment;
        this.myModuleName = moduleName;
    }

    public CvsEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    @Nullable
    public VirtualFile getRootFile() {
        return this.myRootFile;
    }

    public String toString() {
        return this.myEnvironment.getCvsRootAsString() + "|" + this.myModuleName;
    }

    public String toPresentableString() {
        return this.myModuleName;
    }

    public String getKey() {
        return this.myModuleName;
    }

    public void onBeforeBatch() throws VcsException {
    }

    public void onAfterBatch() {
    }
}

