/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsWatch;

import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.cvsSupport2.cvsoperations.cvsWatch.WatcherInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.watchers.WatchersCommand;

public class WatchersOperation
extends CvsOperationOnFiles {
    private final List<WatcherInfo> myWatchers = new ArrayList<WatcherInfo>();

    public WatchersOperation(VirtualFile[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addFile(files[i]);
        }
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        WatchersCommand result = new WatchersCommand();
        this.addFilesToCommand(root, (AbstractCommand)result);
        return result;
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        WatcherInfo info;
        super.messageSent(message, byteMessage, error, tagged);
        if (!error && !tagged && (info = WatcherInfo.createOn(message)) != null) {
            this.myWatchers.add(info);
        }
    }

    @Override
    protected String getOperationName() {
        return "watchers";
    }

    public List<WatcherInfo> getWatchers() {
        return this.myWatchers;
    }
}

