/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.impl.reference.AntPropertyReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AntPropertyRefSelectioner
implements ExtendWordSelectionHandler {
    public boolean canSelect(PsiElement e) {
        return AntPropertyRefSelectioner.getRangesToSelect(e).size() > 0;
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> rangesToSelect = AntPropertyRefSelectioner.getRangesToSelect(e);
        Iterator<TextRange> it = rangesToSelect.iterator();
        while (it.hasNext()) {
            TextRange range = it.next();
            if (range.contains(cursorOffset)) continue;
            it.remove();
        }
        return rangesToSelect;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<TextRange> getRangesToSelect(PsiElement e) {
        List<Object> list;
        PsiFile containingFile = e.getContainingFile();
        if (containingFile == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntPropertyRefSelectioner.getRangesToSelect must not return null");
            return list;
        }
        AntFile antFile = AntSupport.getAntFile(containingFile);
        if (antFile == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntPropertyRefSelectioner.getRangesToSelect must not return null");
            return list;
        }
        PsiElement antElement = antFile.findElementAt(e.getTextOffset());
        if (antElement == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntPropertyRefSelectioner.getRangesToSelect must not return null");
            return list;
        }
        TextRange antElementRange = antElement.getTextRange();
        TextRange selectionElementRange = e.getTextRange();
        PsiReference[] refs = antElement.getReferences();
        ArrayList<TextRange> ranges = new ArrayList<TextRange>(refs.length);
        for (PsiReference ref : refs) {
            if (!(ref instanceof AntPropertyReference)) continue;
            TextRange refRange = ref.getRangeInElement();
            if (!selectionElementRange.contains(refRange = refRange.shiftRight(antElementRange.getStartOffset()))) continue;
            ranges.add(refRange);
        }
        list = ranges;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntPropertyRefSelectioner.getRangesToSelect must not return null");
    }
}

