/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic.x86;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;

public class X86CFrame
extends BasicCFrame {
    private Address ebp;
    private Address pc;
    private static final int ADDRESS_SIZE = 4;

    public X86CFrame(CDebugger dbg, Address ebp, Address pc) {
        super(dbg);
        this.ebp = ebp;
        this.pc = pc;
    }

    @Override
    public CFrame sender() {
        if (this.ebp == null) {
            return null;
        }
        Address nextEBP = this.ebp.getAddressAt(0L);
        if (nextEBP == null) {
            return null;
        }
        Address nextPC = this.ebp.getAddressAt(4L);
        if (nextPC == null) {
            return null;
        }
        return new X86CFrame(this.dbg(), nextEBP, nextPC);
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.ebp;
    }
}

