/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.ia64;

import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.ia64.IA64JavaCallWrapper;
import sun.jvm.hotspot.runtime.ia64.IA64RegisterMap;
import sun.jvm.hotspot.runtime.ia64.cInterpreter;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class IA64Frame
extends Frame {
    private static final boolean DEBUG = false;
    Address iframe;

    private IA64Frame() {
    }

    public IA64Frame(Address raw_sp, Address iframe, Address pc) {
        this.raw_sp = raw_sp;
        this.iframe = iframe;
        this.pc = pc;
    }

    @Override
    public Object clone() {
        IA64Frame frame = new IA64Frame();
        frame.raw_sp = this.raw_sp;
        frame.iframe = this.iframe;
        frame.pc = this.pc;
        return frame;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof IA64Frame)) {
            return false;
        }
        IA64Frame other = (IA64Frame)arg;
        return AddressOps.equal(this.getSP(), other.getSP()) && AddressOps.equal(this.getIFRAME(), other.getIFRAME()) && AddressOps.equal(this.getPC(), other.getPC());
    }

    public int hashCode() {
        if (this.iframe == null) {
            return 0;
        }
        return ((Object)this.iframe).hashCode();
    }

    public String toString() {
        return "sp: " + (this.getSP() == null ? "null" : this.getSP().toString()) + ", iframe: " + (this.getIFRAME() == null ? "null" : this.getIFRAME().toString()) + ", pc: " + (this.pc == null ? "null" : this.pc.toString());
    }

    @Override
    public Address getFP() {
        return null;
    }

    public Address getIFRAME() {
        return this.iframe;
    }

    @Override
    public Address getSP() {
        return this.raw_sp;
    }

    @Override
    public Address getID() {
        return this.getFP();
    }

    @Override
    public boolean isSignalHandlerFrameDbg() {
        return false;
    }

    @Override
    public int getSignalNumberDbg() {
        return 0;
    }

    @Override
    public String getSignalNameDbg() {
        return null;
    }

    @Override
    public boolean isInterpretedFrameValid() {
        return true;
    }

    @Override
    public boolean isInterpretedFrame() {
        return this.iframe != null;
    }

    @Override
    public Frame sender(RegisterMap regMap, CodeBlob cb) {
        if (this.iframe == null) {
            return null;
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        if (fr.prev() == null) {
            Address wrapper = fr.wrapper();
            if (wrapper == null) {
                return null;
            }
            IA64JavaCallWrapper jcw = new IA64JavaCallWrapper(wrapper);
            Address iprev = jcw.getPrevIFrame();
            if (iprev == null) {
                return null;
            }
            return new IA64Frame(null, iprev, null);
        }
        return new IA64Frame(null, fr.prev(), null);
    }

    private Frame senderForEntryFrame(IA64RegisterMap map) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        throw new RuntimeException("senderForEntryFrame NYI");
    }

    private Frame senderForInterpreterFrame(IA64RegisterMap map) {
        throw new RuntimeException("senderForInterpreterFrame NYI");
    }

    private Frame senderForDeoptimizedFrame(IA64RegisterMap map, CodeBlob cb) {
        throw new RuntimeException("Deoptimized frames not handled yet");
    }

    private Frame senderForCompiledFrame(IA64RegisterMap map, CodeBlob cb) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        throw new RuntimeException("senderForCompiledFrame NYI");
    }

    @Override
    protected boolean hasSenderPD() {
        return true;
    }

    @Override
    public long frameSize() {
        throw new RuntimeException("frameSize NYI");
    }

    @Override
    public Address getLink() {
        throw new RuntimeException("getLink NYI");
    }

    @Override
    public Address getUnextendedSP() {
        return this.getSP();
    }

    @Override
    public Address getSenderPC() {
        return null;
    }

    @Override
    public Address getSenderSP() {
        return null;
    }

    @Override
    public Address addressOfInterpreterFrameLocals() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        return fr.locals();
    }

    private Address addressOfInterpreterFrameBCX() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        return fr.bcpAddr();
    }

    @Override
    public int getInterpreterFrameBCI() {
        Address bcp = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        OopHandle methodHandle = this.addressOfInterpreterFrameMethod().getOopHandleAt(0L);
        Method method = (Method)VM.getVM().getObjectHeap().newOop(methodHandle);
        return this.bcpToBci(bcp, method);
    }

    public Address addressOfInterpreterFrameMDX() {
        return null;
    }

    @Override
    public Address addressOfInterpreterFrameExpressionStack() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        return fr.stackBase();
    }

    @Override
    public int getInterpreterFrameExpressionStackDirection() {
        return -1;
    }

    @Override
    public Address addressOfInterpreterFrameTOS() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        return fr.stackBase().addOffsetTo(VM.getVM().getAddressSize());
    }

    @Override
    public Address addressOfInterpreterFrameTOSAt(int slot) {
        return this.addressOfInterpreterFrameTOS().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    @Override
    public Address getInterpreterFrameSenderSP() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "interpreted frame expected");
        }
        throw new RuntimeException("getInterpreterFrameSenderSP NYI");
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorBegin() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        return new BasicObjectLock(fr.monitorBase());
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorEnd() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        Address result = fr.stackBase().addOffsetTo(2L * VM.getVM().getAddressSize());
        return new BasicObjectLock(result);
    }

    @Override
    public int interpreterFrameMonitorSize() {
        return BasicObjectLock.size();
    }

    @Override
    public Address addressOfInterpreterFrameMethod() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        return fr.methodAddr();
    }

    @Override
    public Address addressOfInterpreterFrameCPCache() {
        if (this.iframe == null) {
            throw new RuntimeException("Not an Interpreter frame");
        }
        cInterpreter fr = new cInterpreter(this.iframe);
        return fr.constantsAddr();
    }

    @Override
    public JavaCallWrapper getEntryFrameCallWrapper() {
        throw new RuntimeException("getEntryFrameCallWrapper NYI");
    }

    @Override
    protected Address addressOfSavedOopResult() {
        throw new RuntimeException("public boolean isInterpretedFrame() NYI");
    }

    @Override
    protected Address addressOfSavedReceiver() {
        throw new RuntimeException("getEntryFrameCallWrapper NYI");
    }

    private void dumpStack() {
    }
}

