/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.sparc;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.sparc.SPARCFrame;
import sun.jvm.hotspot.types.TypeDataBase;

public class SPARCRicochetFrame {
    private SPARCFrame frame;

    private static void initialize(TypeDataBase db) {
    }

    static SPARCRicochetFrame fromFrame(SPARCFrame f) {
        return new SPARCRicochetFrame(f);
    }

    private SPARCRicochetFrame(SPARCFrame f) {
        this.frame = f;
    }

    private Address registerValue(SPARCRegister reg) {
        return this.frame.getSP().addOffsetTo(reg.spOffsetInSavedWindow()).getAddressAt(0L);
    }

    public Address savedArgsBase() {
        return this.registerValue(SPARCRegisters.L4);
    }

    public Address exactSenderSP() {
        return this.registerValue(SPARCRegisters.I5);
    }

    public Address senderLink() {
        return this.frame.getSenderSP();
    }

    public Address senderPC() {
        return this.frame.getSenderPC();
    }

    public Address extendedSenderSP() {
        return this.savedArgsBase();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                SPARCRicochetFrame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

