/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.win32_amd64;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.amd64.AMD64CurrentFrameGuess;
import sun.jvm.hotspot.runtime.x86.X86Frame;
import sun.jvm.hotspot.runtime.x86.X86RegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class Win32AMD64JavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField lastJavaFPField;
    private static AddressField osThreadField;
    private static Field osThreadThreadHandleField;
    private static final long GUESS_SCAN_RANGE = 131072L;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        lastJavaFPField = anchorType.getAddressField("_last_Java_fp");
        osThreadField = type.getAddressField("_osthread");
        type = db.lookupType("OSThread");
        osThreadThreadHandleField = type.getField("_thread_handle");
    }

    @Override
    public Address getLastJavaFP(Address addr) {
        return lastJavaFPField.getValue(addr.addOffsetTo(JavaThread.getAnchorField().getOffset()));
    }

    @Override
    public Address getLastJavaPC(Address addr) {
        return null;
    }

    @Override
    public Address getBaseOfStackPointer(Address addr) {
        return null;
    }

    @Override
    public Frame getLastFramePD(JavaThread thread, Address addr) {
        Address fp = thread.getLastJavaFP();
        if (fp == null) {
            return null;
        }
        Address pc = thread.getLastJavaPC();
        if (pc != null) {
            return new X86Frame(thread.getLastJavaSP(), fp, pc);
        }
        return new X86Frame(thread.getLastJavaSP(), fp);
    }

    @Override
    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new X86RegisterMap(thread, updateMap);
    }

    @Override
    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        AMD64ThreadContext context = (AMD64ThreadContext)t.getContext();
        AMD64CurrentFrameGuess guesser = new AMD64CurrentFrameGuess(context, thread);
        if (!guesser.run(131072L)) {
            return null;
        }
        if (guesser.getPC() == null) {
            return new X86Frame(guesser.getSP(), guesser.getFP());
        }
        return new X86Frame(guesser.getSP(), guesser.getFP(), guesser.getPC());
    }

    @Override
    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    @Override
    public void printInfoOn(Address threadAddr, PrintStream tty) {
    }

    @Override
    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        AMD64ThreadContext context = (AMD64ThreadContext)t.getContext();
        return context.getRegisterAsAddress(20);
    }

    @Override
    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address threadHandleAddr = osThreadAddr.addOffsetTo(osThreadThreadHandleField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(threadHandleAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Win32AMD64JavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

