/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.audio;

import java.awt.event.ActionEvent;
import java.net.URL;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AudioPlayPauseAction
extends JosmAction {
    public AudioPlayPauseAction() {
        super(I18n.trc("audio", "Play/Pause"), "audio-playpause", I18n.tr("Play/pause audio."), Shortcut.registerShortcut("audio:pause", I18n.tr("Audio: {0}", I18n.trc("audio", "Play/Pause")), 46, 5), true);
    }

    public void actionPerformed(ActionEvent e) {
        URL url = AudioPlayer.url();
        try {
            if (AudioPlayer.paused() && url != null) {
                AudioPlayer.play(url);
            } else if (AudioPlayer.playing()) {
                if (AudioPlayer.speed() != 1.0) {
                    AudioPlayer.play(url, AudioPlayer.position());
                } else {
                    AudioPlayer.pause();
                }
            } else {
                MarkerLayer.playAudio();
            }
        }
        catch (Exception ex) {
            AudioPlayer.audioMalfunction(ex);
        }
    }
}

