/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTaskList {
    private List<DownloadTask> osmTasks = new LinkedList<DownloadTask>();
    private List<Future<?>> osmTaskFutures = new LinkedList();
    private ProgressMonitor progressMonitor;

    public Future<?> download(boolean newLayer, List<Rectangle2D> rects, ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        if (newLayer) {
            OsmDataLayer l = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(l);
            Main.map.mapView.setActiveLayer(l);
        }
        progressMonitor.beginTask(null, rects.size());
        int i = 0;
        for (Rectangle2D td : rects) {
            DownloadOsmTask dt = new DownloadOsmTask();
            ProgressMonitor childProgress = progressMonitor.createSubTaskMonitor(1, false);
            childProgress.setCustomText(I18n.tr("Download {0} of {1} ({2} left)", ++i, rects.size(), rects.size() - i));
            Future<?> future = dt.download(false, new Bounds(td), childProgress);
            this.osmTaskFutures.add(future);
            this.osmTasks.add(dt);
        }
        progressMonitor.addCancelListener(new ProgressMonitor.CancelListener(){

            public void operationCanceled() {
                for (DownloadTask dt : DownloadOsmTaskList.this.osmTasks) {
                    dt.cancel();
                }
            }
        });
        return Main.worker.submit(new PostDownloadProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> download(boolean newLayer, Collection<Area> areas, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Updating data"));
        try {
            ArrayList<Rectangle2D> rects = new ArrayList<Rectangle2D>(areas.size());
            for (Area a : areas) {
                rects.add(a.getBounds2D());
            }
            Future<?> future = this.download(newLayer, (List<Rectangle2D>)rects, progressMonitor.createSubTaskMonitor(-1, false));
            return future;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected Set<OsmPrimitive> getCompletePrimitives(DataSet ds) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (OsmPrimitive primitive : ds.allPrimitives()) {
            if (primitive.isIncomplete() || primitive.isNew()) continue;
            ret.add(primitive);
        }
        return ret;
    }

    protected void updatePotentiallyDeletedPrimitives(Set<OsmPrimitive> potentiallyDeleted) {
        final ArrayList<OsmPrimitive> toSelect = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive primitive : potentiallyDeleted) {
            if (primitive == null) continue;
            toSelect.add(primitive);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new UpdateSelectionAction().updatePrimitives(toSelect);
            }
        });
    }

    protected void handlePotentiallyDeletedPrimitives(Set<OsmPrimitive> potentiallyDeleted) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Check on the server"), ImageProvider.get("ok"), I18n.tr("Click to check whether objects in your local dataset are deleted on the server"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Ignore"), ImageProvider.get("cancel"), I18n.tr("Click to abort and to resume editing"), null)};
        String message = "<html>" + I18n.trn("There is {0} object in your local dataset which might be deleted on the server. If you later try to delete or update this the server is likely to report a conflict.", "There are {0} objects in your local dataset which might be deleted on the server. If you later try to delete or update them the server is likely to report a conflict.", potentiallyDeleted.size(), potentiallyDeleted.size()) + "<br>" + I18n.trn("Click <strong>{0}</strong> to check the state of this object on the server.", "Click <strong>{0}</strong> to check the state of these objects on the server.", potentiallyDeleted.size(), options[0].text) + "<br>" + I18n.tr("Click <strong>{0}</strong> to ignore.</html>", options[1].text);
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, message, I18n.tr("Deleted or moved objects"), 2, null, options, options[0], HelpUtil.ht("/Action/UpdateData#SyncPotentiallyDeletedObjects"));
        if (ret != 0) {
            return;
        }
        this.updatePotentiallyDeletedPrimitives(potentiallyDeleted);
    }

    public Set<OsmPrimitive> getDownloadedPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (DownloadTask task : this.osmTasks) {
            DataSet ds;
            if (!(task instanceof DownloadOsmTask) || (ds = ((DownloadOsmTask)task).getDownloadedData()) == null) continue;
            ret.addAll(ds.allPrimitives());
        }
        return ret;
    }

    class PostDownloadProcessor
    implements Runnable {
        PostDownloadProcessor() {
        }

        public void run() {
            DownloadOsmTaskList.this.progressMonitor.finishTask();
            for (Future future : DownloadOsmTaskList.this.osmTaskFutures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            LinkedHashSet<Object> errors = new LinkedHashSet<Object>();
            for (DownloadTask dt : DownloadOsmTaskList.this.osmTasks) {
                errors.addAll(dt.getErrorObjects());
            }
            if (!errors.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (Object e : errors) {
                    if (e instanceof String) {
                        sb.append("<li>").append(e).append("</li>").append("<br>");
                        continue;
                    }
                    if (!(e instanceof Exception)) continue;
                    sb.append("<li>").append(ExceptionUtil.explainException((Exception)e)).append("</li>").append("<br>");
                }
                sb.insert(0, "<ul>");
                sb.append("</ul>");
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("The following errors occurred during mass download: {0}", sb.toString()) + "</html>", I18n.tr("Errors during download"), 0);
                return;
            }
            for (DownloadTask task : DownloadOsmTaskList.this.osmTasks) {
                DownloadOsmTask downloadOsmTask;
                if (!(task instanceof DownloadOsmTask) || !(downloadOsmTask = (DownloadOsmTask)task).isCanceled() && !downloadOsmTask.isFailed()) continue;
                return;
            }
            OsmDataLayer editLayer = Main.map.mapView.getEditLayer();
            if (editLayer != null) {
                Set<OsmPrimitive> myPrimitives = DownloadOsmTaskList.this.getCompletePrimitives(editLayer.data);
                for (DownloadTask task : DownloadOsmTaskList.this.osmTasks) {
                    DataSet ds;
                    if (!(task instanceof DownloadOsmTask) || (ds = ((DownloadOsmTask)task).getDownloadedData()) == null) continue;
                    myPrimitives.removeAll(ds.allPrimitives());
                }
                if (!myPrimitives.isEmpty()) {
                    DownloadOsmTaskList.this.handlePotentiallyDeletedPrimitives(myPrimitives);
                }
            }
        }
    }
}

