/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicUploadDependencyException
extends Exception {
    private Stack<Relation> cycle;

    public CyclicUploadDependencyException(Stack<Relation> cycle) {
        this.cycle = cycle;
    }

    protected String formatRelation(Relation r) {
        StringBuffer sb = new StringBuffer();
        if (r.getName() != null) {
            sb.append("'").append(r.getName()).append("'");
        } else if (!r.isNew()) {
            sb.append(r.getId());
        } else {
            sb.append("relation@").append(r.hashCode());
        }
        return sb.toString();
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(I18n.tr("Cyclic dependency between relations:"));
        sb.append("[");
        for (int i = 0; i < this.cycle.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.formatRelation((Relation)this.cycle.get(i)));
        }
        sb.append("]");
        return sb.toString();
    }

    public List<Relation> getCyclicUploadDependency() {
        return new ArrayList<Relation>(this.cycle);
    }
}

