/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlObjectParser;

public class ServerSidePreferences
extends Preferences {
    private static final Logger logger = Logger.getLogger(ServerSidePreferences.class.getName());
    private final Connection connection;

    public ServerSidePreferences(URL serverUrl) {
        Connection connection = null;
        try {
            connection = new Connection(new URL(serverUrl + "user/preferences"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not load preferences from server."), I18n.tr("Error"), 0);
        }
        this.connection = connection;
    }

    public String getPreferencesDir() {
        return this.connection.serverUrl.toString();
    }

    public void load() {
    }

    public void save() {
    }

    public void download(String userName, String password) {
        if (!this.properties.containsKey("osm-server.username") && userName != null) {
            this.properties.put("osm-server.username", userName);
        }
        if (!this.properties.containsKey("osm-server.password") && password != null) {
            this.properties.put("osm-server.password", password);
        }
        this.download();
    }

    public boolean download() {
        this.resetToDefault();
        String cont = this.connection.download();
        if (cont == null) {
            return false;
        }
        StringReader in = new StringReader(cont);
        boolean res = false;
        try {
            XmlObjectParser.Uniform<Prop> parser = new XmlObjectParser.Uniform<Prop>(in, "tag", Prop.class);
            for (Prop p : parser) {
                res = true;
                this.properties.put(p.key, p.value);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return res;
    }

    public void upload() {
        StringBuilder b = new StringBuilder("<preferences>\n");
        for (Map.Entry p : this.properties.entrySet()) {
            if (((String)p.getKey()).equals("osm-server.password")) continue;
            b.append("<tag key='");
            b.append(XmlWriter.encode((String)p.getKey()));
            b.append("' value='");
            b.append(XmlWriter.encode((String)p.getValue()));
            b.append("' />\n");
        }
        b.append("</preferences>");
        this.connection.upload(b.toString());
    }

    public static class Prop {
        public String key;
        public String value;
    }

    private class Connection
    extends OsmConnection {
        URL serverUrl;

        public Connection(URL serverUrl) {
            this.serverUrl = serverUrl;
        }

        public String download() {
            try {
                System.out.println("reading preferences from " + this.serverUrl);
                URLConnection con = this.serverUrl.openConnection();
                if (con instanceof HttpURLConnection) {
                    this.addAuth((HttpURLConnection)con);
                }
                con.connect();
                BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder b = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    b.append(line);
                    b.append("\n");
                    line = reader.readLine();
                }
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                return b.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (OsmTransferException e) {
                e.printStackTrace();
            }
            return null;
        }

        public void upload(String s) {
            try {
                URL u = new URL(ServerSidePreferences.this.getPreferencesDir());
                System.out.println("uploading preferences to " + u);
                HttpURLConnection con = (HttpURLConnection)u.openConnection();
                con.addRequestProperty("Authorization", "Basic " + Base64.encode(ServerSidePreferences.this.get("osm-server.username") + ":" + ServerSidePreferences.this.get("osm-server.password")));
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                con.connect();
                PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutputStream()));
                out.println(s);
                out.close();
                con.getInputStream().close();
                con.disconnect();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Preferences stored on {0}", u.getHost()), I18n.tr("Information"), 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not upload preferences. Reason: {0}", e.getMessage()), I18n.tr("Error"), 0);
            }
        }
    }
}

