/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.openstreetmap.josm.data.projection.NTV2GridShift;
import org.openstreetmap.josm.data.projection.NTV2Util;

public class NTV2SubGrid
implements Cloneable,
Serializable {
    private String subGridName;
    private String parentSubGridName;
    private String created;
    private String updated;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private double latInterval;
    private double lonInterval;
    private int nodeCount;
    private int lonColumnCount;
    private int latRowCount;
    private float[] latShift;
    private float[] lonShift;
    private float[] latAccuracy;
    private float[] lonAccuracy;
    boolean bigEndian;
    private NTV2SubGrid[] subGrid;

    public NTV2SubGrid(InputStream in, boolean bigEndian, boolean loadAccuracy) throws IOException {
        byte[] b8 = new byte[8];
        byte[] b4 = new byte[4];
        byte[] b1 = new byte[1];
        in.read(b8);
        in.read(b8);
        this.subGridName = new String(b8).trim();
        in.read(b8);
        in.read(b8);
        this.parentSubGridName = new String(b8).trim();
        in.read(b8);
        in.read(b8);
        this.created = new String(b8);
        in.read(b8);
        in.read(b8);
        this.updated = new String(b8);
        in.read(b8);
        in.read(b8);
        this.minLat = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.maxLat = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.minLon = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.maxLon = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.latInterval = NTV2Util.getDouble(b8, bigEndian);
        in.read(b8);
        in.read(b8);
        this.lonInterval = NTV2Util.getDouble(b8, bigEndian);
        this.lonColumnCount = 1 + (int)((this.maxLon - this.minLon) / this.lonInterval);
        this.latRowCount = 1 + (int)((this.maxLat - this.minLat) / this.latInterval);
        in.read(b8);
        in.read(b8);
        this.nodeCount = NTV2Util.getInt(b8, bigEndian);
        if (this.nodeCount != this.lonColumnCount * this.latRowCount) {
            throw new IllegalStateException("SubGrid " + this.subGridName + " has inconsistent grid dimesions");
        }
        this.latShift = new float[this.nodeCount];
        this.lonShift = new float[this.nodeCount];
        if (loadAccuracy) {
            this.latAccuracy = new float[this.nodeCount];
            this.lonAccuracy = new float[this.nodeCount];
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            in.read(b1);
            b4[0] = b1[0];
            in.read(b1);
            b4[1] = b1[0];
            in.read(b1);
            b4[2] = b1[0];
            in.read(b1);
            b4[3] = b1[0];
            this.latShift[i] = NTV2Util.getFloat(b4, bigEndian);
            in.read(b1);
            b4[0] = b1[0];
            in.read(b1);
            b4[1] = b1[0];
            in.read(b1);
            b4[2] = b1[0];
            in.read(b1);
            b4[3] = b1[0];
            this.lonShift[i] = NTV2Util.getFloat(b4, bigEndian);
            in.read(b1);
            b4[0] = b1[0];
            in.read(b1);
            b4[1] = b1[0];
            in.read(b1);
            b4[2] = b1[0];
            in.read(b1);
            b4[3] = b1[0];
            if (loadAccuracy) {
                this.latAccuracy[i] = NTV2Util.getFloat(b4, bigEndian);
            }
            in.read(b1);
            b4[0] = b1[0];
            in.read(b1);
            b4[1] = b1[0];
            in.read(b1);
            b4[2] = b1[0];
            in.read(b1);
            b4[3] = b1[0];
            if (!loadAccuracy) continue;
            this.lonAccuracy[i] = NTV2Util.getFloat(b4, bigEndian);
        }
    }

    public NTV2SubGrid getSubGridForCoord(double lon, double lat) {
        if (this.isCoordWithin(lon, lat)) {
            if (this.subGrid == null) {
                return this;
            }
            for (int i = 0; i < this.subGrid.length; ++i) {
                if (!this.subGrid[i].isCoordWithin(lon, lat)) continue;
                return this.subGrid[i].getSubGridForCoord(lon, lat);
            }
            return this;
        }
        return null;
    }

    private boolean isCoordWithin(double lon, double lat) {
        return lon >= this.minLon && lon < this.maxLon && lat >= this.minLat && lat < this.maxLat;
    }

    private final double interpolate(float a, float b, float c, float d, double X, double Y) {
        return (double)a + ((double)b - (double)a) * X + ((double)c - (double)a) * Y + ((double)a + (double)d - (double)b - (double)c) * X * Y;
    }

    public NTV2GridShift interpolateGridShift(NTV2GridShift gs) {
        int lonIndex = (int)((gs.getLonPositiveWestSeconds() - this.minLon) / this.lonInterval);
        int latIndex = (int)((gs.getLatSeconds() - this.minLat) / this.latInterval);
        double X = (gs.getLonPositiveWestSeconds() - (this.minLon + this.lonInterval * (double)lonIndex)) / this.lonInterval;
        double Y = (gs.getLatSeconds() - (this.minLat + this.latInterval * (double)latIndex)) / this.latInterval;
        int indexA = lonIndex + latIndex * this.lonColumnCount;
        int indexB = indexA + 1;
        int indexC = indexA + this.lonColumnCount;
        int indexD = indexC + 1;
        gs.setLonShiftPositiveWestSeconds(this.interpolate(this.lonShift[indexA], this.lonShift[indexB], this.lonShift[indexC], this.lonShift[indexD], X, Y));
        gs.setLatShiftSeconds(this.interpolate(this.latShift[indexA], this.latShift[indexB], this.latShift[indexC], this.latShift[indexD], X, Y));
        if (this.lonAccuracy == null) {
            gs.setLonAccuracyAvailable(false);
        } else {
            gs.setLonAccuracyAvailable(true);
            gs.setLonAccuracySeconds(this.interpolate(this.lonAccuracy[indexA], this.lonAccuracy[indexB], this.lonAccuracy[indexC], this.lonAccuracy[indexD], X, Y));
        }
        if (this.latAccuracy == null) {
            gs.setLatAccuracyAvailable(false);
        } else {
            gs.setLatAccuracyAvailable(true);
            gs.setLatAccuracySeconds(this.interpolate(this.latAccuracy[indexA], this.latAccuracy[indexB], this.latAccuracy[indexC], this.latAccuracy[indexD], X, Y));
        }
        return gs;
    }

    public String getParentSubGridName() {
        return this.parentSubGridName;
    }

    public String getSubGridName() {
        return this.subGridName;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getSubGridCount() {
        return this.subGrid == null ? 0 : this.subGrid.length;
    }

    public NTV2SubGrid getSubGrid(int index) {
        return this.subGrid == null ? null : this.subGrid[index];
    }

    public void setSubGridArray(NTV2SubGrid[] subGrid) {
        this.subGrid = subGrid;
    }

    public String toString() {
        return this.subGridName;
    }

    public String getDetails() {
        StringBuffer buf = new StringBuffer("Sub Grid : ");
        buf.append(this.subGridName);
        buf.append("\nParent   : ");
        buf.append(this.parentSubGridName);
        buf.append("\nCreated  : ");
        buf.append(this.created);
        buf.append("\nUpdated  : ");
        buf.append(this.updated);
        buf.append("\nMin Lat  : ");
        buf.append(this.minLat);
        buf.append("\nMax Lat  : ");
        buf.append(this.maxLat);
        buf.append("\nMin Lon  : ");
        buf.append(this.minLon);
        buf.append("\nMax Lon  : ");
        buf.append(this.maxLon);
        buf.append("\nLat Intvl: ");
        buf.append(this.latInterval);
        buf.append("\nLon Intvl: ");
        buf.append(this.lonInterval);
        buf.append("\nNode Cnt : ");
        buf.append(this.nodeCount);
        return buf.toString();
    }

    public Object clone() {
        NTV2SubGrid clone = null;
        try {
            clone = (NTV2SubGrid)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            // empty catch block
        }
        if (this.subGrid != null) {
            clone.subGrid = new NTV2SubGrid[this.subGrid.length];
            for (int i = 0; i < this.subGrid.length; ++i) {
                clone.subGrid[i] = (NTV2SubGrid)this.subGrid[i].clone();
            }
        }
        return clone;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }
}

